/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledChoice
extends JPanel
implements JLabeledField {
    private JLabel mLabel = new JLabel();
    private JComboBox choiceList;
    private ArrayList mChangeListeners = new ArrayList(3);
    private JButton delete;
    private JButton add;

    public JLabeledChoice() {
        this.choiceList = new JComboBox();
        this.init();
    }

    public List getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.choiceList);
        return comps;
    }

    public JLabeledChoice(String pLabel, boolean editable) {
        this.choiceList = new JComboBox();
        this.mLabel.setText(pLabel);
        this.choiceList.setEditable(editable);
        this.init();
    }

    public void setEditable(boolean editable) {
        this.choiceList.setEditable(false);
    }

    public void addValue(String item) {
        this.choiceList.addItem(item);
    }

    public void setValues(String[] items) {
        this.choiceList.removeAllItems();
        int i = 0;
        while (i < items.length) {
            this.choiceList.addItem(items[i]);
            ++i;
        }
    }

    public JLabeledChoice(String pLabel, String[] items) {
        this.mLabel.setText(pLabel);
        this.choiceList = new JComboBox<String>(items);
        this.choiceList.setEditable(false);
        this.init();
    }

    public JLabeledChoice(String pLabel, String[] items, boolean editable) {
        this.mLabel.setText(pLabel);
        this.choiceList = new JComboBox<String>(items);
        this.choiceList.setEditable(editable);
        this.init();
    }

    private void init() {
        this.choiceList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.choiceList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JLabeledChoice.this.notifyChangeListeners();
                }
            }
        });
        this.add(this.mLabel);
        this.add(this.choiceList);
        if (this.choiceList.isEditable()) {
            this.add = new JButton("Add");
            this.add.setMargin(new Insets(1, 1, 1, 1));
            this.add.addActionListener(new AddListener());
            this.add(this.add);
            this.delete = new JButton("Del");
            this.delete.setMargin(new Insets(1, 1, 1, 1));
            this.delete.addActionListener(new DeleteListener());
            this.add(this.delete);
        }
    }

    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    public void setText(String pText) {
        this.choiceList.setSelectedItem(pText);
    }

    public String getText() {
        return (String)this.choiceList.getSelectedItem();
    }

    public Object[] getSelectedItems() {
        return this.choiceList.getSelectedObjects();
    }

    public String[] getItems() {
        String[] items = new String[this.choiceList.getItemCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = (String)this.choiceList.getItemAt(i);
            ++i;
        }
        return items;
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        int index = 0;
        while (index < this.mChangeListeners.size()) {
            ((ChangeListener)this.mChangeListeners.get(index)).stateChanged(ce);
            ++index;
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JLabeledChoice.this.choiceList.getItemCount() > 1) {
                JLabeledChoice.this.choiceList.removeItemAt(JLabeledChoice.this.choiceList.getSelectedIndex());
                JLabeledChoice.this.notifyChangeListeners();
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object item = JLabeledChoice.this.choiceList.getSelectedItem();
            int index = JLabeledChoice.this.choiceList.getSelectedIndex();
            if (!item.equals(JLabeledChoice.this.choiceList.getItemAt(index))) {
                JLabeledChoice.this.choiceList.addItem(item);
            }
            JLabeledChoice.this.choiceList.setSelectedItem(item);
            JLabeledChoice.this.notifyChangeListeners();
        }
    }
}

