/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ObjectTableModel
extends DefaultTableModel {
    private static Logger log = LoggingManager.getLoggerFor("jorphan.gui");
    private transient ArrayList objects = new ArrayList();
    private transient List headers = new ArrayList();
    private transient ArrayList classes = new ArrayList();
    private transient Class objectClass;
    private transient ArrayList setMethods = new ArrayList();
    private transient ArrayList getMethods = new ArrayList();
    static /* synthetic */ Class class$java$lang$Boolean;

    public ObjectTableModel(String[] headers, String[] propertyNames, Class[] propertyClasses, Class[] renderClasses, Object sampleObject) {
        this.headers.addAll(Arrays.asList(headers));
        this.classes.addAll(Arrays.asList(renderClasses));
        this.objectClass = sampleObject.getClass();
        Class[] emptyClasses = new Class[]{};
        int i = 0;
        while (i < propertyNames.length) {
            propertyNames[i] = propertyNames[i].substring(0, 1).toUpperCase() + propertyNames[i].substring(1);
            try {
                if (!propertyClasses[i].equals(class$java$lang$Boolean == null ? ObjectTableModel.class$("java.lang.Boolean") : class$java$lang$Boolean) && !propertyClasses[i].equals(Boolean.TYPE)) {
                    this.getMethods.add(this.objectClass.getMethod("get" + propertyNames[i], emptyClasses));
                } else {
                    this.getMethods.add(this.objectClass.getMethod("is" + propertyNames[i], emptyClasses));
                }
                this.setMethods.add(this.objectClass.getMethod("set" + propertyNames[i], propertyClasses[i]));
            }
            catch (NoSuchMethodException e) {
                log.error("Invalid Method name for class: " + this.objectClass, (Throwable)e);
            }
            ++i;
        }
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    public void clearData() {
        int size = this.getRowCount();
        this.objects.clear();
        super.fireTableRowsDeleted(0, size);
    }

    public void addRow(Object value) {
        this.objects.add(value);
        super.fireTableRowsInserted(this.objects.size() - 1, this.objects.size());
    }

    public int getColumnCount() {
        return this.headers.size();
    }

    public String getColumnName(int col) {
        return (String)this.headers.get(col);
    }

    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    public Object getValueAt(int row, int col) {
        Object value = this.objects.get(row);
        Method getMethod = (Method)this.getMethods.get(col);
        try {
            return getMethod.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.error("Illegal method access", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("incorrect method access", (Throwable)e);
        }
        return null;
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return true;
    }

    public void moveRow(int start, int end, int to) {
        List subList = this.objects.subList(start, end);
        int x = end - 1;
        while (x >= start) {
            this.objects.remove(x);
            --x;
        }
        this.objects.addAll(to, subList);
        super.fireTableChanged(new TableModelEvent(this));
    }

    public void removeRow(int row) {
        this.objects.remove(row);
        super.fireTableRowsDeleted(row, row);
    }

    public void setValueAt(Object cellValue, int row, int col) {
        if (row < this.objects.size()) {
            Object value = this.objects.get(row);
            if (col < this.setMethods.size()) {
                Method setMethod = (Method)this.setMethods.get(col);
                try {
                    setMethod.invoke(value, cellValue);
                }
                catch (IllegalAccessException e) {
                    log.error("Illegal method access", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("incorrect method access", (Throwable)e);
                }
                super.fireTableDataChanged();
            }
        }
    }

    public Class getColumnClass(int arg0) {
        return (Class)this.classes.get(arg0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

