/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.logging;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import org.apache.jorphan.util.ClassContext;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.NullOutputLogTarget;
import org.apache.log.output.io.WriterTarget;

public class LoggingManager {
    private static PatternFormatter format = new PatternFormatter("%{time:MM/dd/yyyy h:mm:ss a} %5.5{priority} - %{category}: %{message} %{throwable}\n");
    private static LogTarget target;
    public static final String LOG_FILE = "log_file";
    public static final String LOG_PRIORITY = "log_level";
    private static LoggingManager logManager;
    private static final String PACKAGE_PREFIX = "org.apache.";

    private LoggingManager() {
        target = new NullOutputLogTarget();
    }

    public static LoggingManager getLogManager() {
        return logManager;
    }

    public static void initializeLogging(Properties properties) {
        if (logManager == null) {
            logManager = new LoggingManager();
        }
        LoggingManager.setTarget(LoggingManager.makeWriter(properties.getProperty(LOG_FILE, "jmeter.log"), LOG_FILE));
        LoggingManager.setPriority(properties.getProperty(LOG_PRIORITY, "INFO"));
        LoggingManager.setLoggingLevels(properties);
    }

    private static Writer makeWriter(String logFile, String propName) {
        Writer wt;
        try {
            wt = new FileWriter(logFile);
        }
        catch (Exception e) {
            System.out.println(propName + "=" + logFile + " " + e.toString());
            System.out.println("[" + propName + "-> System.out]");
            wt = new PrintWriter(System.out);
        }
        return wt;
    }

    private static void setLoggingLevels(Properties appProperties) {
        Iterator<Object> props = appProperties.keySet().iterator();
        while (props.hasNext()) {
            String category;
            String prop = (String)props.next();
            if (prop.startsWith("log_level.")) {
                category = prop.substring(LOG_PRIORITY.length() + 1);
                LoggingManager.setPriority(appProperties.getProperty(prop), category);
            }
            if (!prop.startsWith("log_file.")) continue;
            category = prop.substring(LOG_FILE.length() + 1);
            String file = appProperties.getProperty(prop);
            LoggingManager.setTarget((LogTarget)new WriterTarget(LoggingManager.makeWriter(file, prop), (Formatter)format), category);
        }
    }

    private static String getCallerClassName() {
        String name = ClassContext.getCallerClassNameAt(3);
        if (name.startsWith(PACKAGE_PREFIX)) {
            name = name.substring(PACKAGE_PREFIX.length());
        }
        return name;
    }

    public static Logger getLoggerForClass() {
        String className = LoggingManager.getCallerClassName();
        return Hierarchy.getDefaultHierarchy().getLoggerFor(className);
    }

    public static Logger getLoggerForClass(String unused) {
        String className = LoggingManager.getCallerClassName();
        return Hierarchy.getDefaultHierarchy().getLoggerFor(className);
    }

    public static Logger getLoggerFor(String category) {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(category);
    }

    public static void setPriority(String p, String category) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)p), category);
    }

    public static void setPriority(Priority p, String category) {
        Hierarchy.getDefaultHierarchy().getLoggerFor(category).setPriority(p);
    }

    public static void setPriority(String p) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)p));
    }

    public static void setPriority(Priority p) {
        Hierarchy.getDefaultHierarchy().setDefaultPriority(p);
    }

    public static void setTarget(LogTarget target, String category) {
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(category);
        logger.setLogTargets(new LogTarget[]{target});
    }

    public static void setTarget(Writer targetFile) {
        if (target == null) {
            target = new WriterTarget(targetFile, (Formatter)format);
        } else {
            if (target instanceof WriterTarget) {
                ((WriterTarget)target).close();
            }
            target = new WriterTarget(targetFile, (Formatter)format);
        }
        Hierarchy.getDefaultHierarchy().setDefaultLogTarget(target);
    }

    static {
        logManager = null;
    }
}

