/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class StatCalculator
implements Serializable {
    List values = new ArrayList();
    double sum = 0.0;
    double sumOfSquares = 0.0;
    double mean = 0.0;
    double deviation = 0.0;
    int count = 0;

    public void clear() {
        this.values.clear();
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.mean = 0.0;
        this.deviation = 0.0;
        this.count = 0;
    }

    public void addValue(long newValue) {
        Long val = new Long(newValue);
        this.addValue(val);
    }

    public void addValue(int newValue) {
        Integer val = new Integer(newValue);
        this.addValue(val);
    }

    public void addValue(float newValue) {
        Float val = new Float(newValue);
        this.addValue(val);
    }

    public void addValue(double newValue) {
        Double val = new Double(newValue);
        this.addValue(val);
    }

    public Number getMedian() {
        return (Number)this.values.get(this.values.size() / 2);
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.deviation;
    }

    public Number getMin() {
        return (Number)this.values.get(0);
    }

    public Number getMax() {
        return (Number)this.values.get(this.count - 1);
    }

    public int getCount() {
        return this.count;
    }

    public void addValue(Number val) {
        int index = Collections.binarySearch(this.values, val);
        if (index >= 0 && index < this.values.size()) {
            this.values.add(index, val);
        } else if (index == this.values.size() || this.values.size() == 0) {
            this.values.add(val);
        } else {
            this.values.add(index * -1 - 1, val);
        }
        ++this.count;
        double currentVal = val.doubleValue();
        this.sum += currentVal;
        this.sumOfSquares += currentVal * currentVal;
        this.mean = this.sum / (double)this.count;
        this.deviation = Math.sqrt(this.sumOfSquares / (double)this.count - this.mean * this.mean);
    }

    public static class Test
    extends TestCase {
        StatCalculator calc;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.calc = new StatCalculator();
        }

        public void testCalculation() {
            this.calc.addValue(18);
            this.calc.addValue(10);
            this.calc.addValue(9);
            this.calc.addValue(11);
            this.calc.addValue(28);
            this.calc.addValue(3);
            this.calc.addValue(30);
            this.calc.addValue(15);
            this.calc.addValue(15);
            this.calc.addValue(21);
            Assert.assertEquals((int)16, (int)((int)this.calc.getMean()));
            Assert.assertEquals((float)8.062258f, (float)((float)this.calc.getStandardDeviation()), (float)0.0f);
            Assert.assertEquals((int)30, (int)this.calc.getMax().intValue());
            Assert.assertEquals((int)3, (int)this.calc.getMin().intValue());
            Assert.assertEquals((int)15, (int)this.calc.getMedian().intValue());
        }
    }
}

