/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ClassFinder {
    private static transient Logger log = LoggingManager.getLoggerForClass();

    private ClassFinder() {
    }

    public static List findClassesThatExtend(String[] paths, Class[] superClasses) throws IOException, ClassNotFoundException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        int i = 0;
        while (i < paths.length) {
            File dir;
            fullList.add(paths[i]);
            if (!paths[i].endsWith(".jar") && (dir = new File(paths[i])).exists() && dir.isDirectory()) {
                String[] jars = dir.list(new FilenameFilter(){

                    public boolean accept(File f, String name) {
                        return name.endsWith(".jar");
                    }
                });
                int x = 0;
                while (x < jars.length) {
                    fullList.add(jars[x]);
                    ++x;
                }
            }
            ++i;
        }
        return fullList.toArray(new String[0]);
    }

    public static List findClassesThatExtend(String[] strPathsOrJars, Class[] superClasses, boolean innerClasses) throws IOException, ClassNotFoundException {
        List listPaths = null;
        ArrayList listClasses = null;
        ArrayList<String> listSuperClasses = null;
        strPathsOrJars = ClassFinder.addJarsInPath(strPathsOrJars);
        if (log.isDebugEnabled()) {
            int k = 0;
            while (k < strPathsOrJars.length) {
                log.debug("strPathsOrJars : " + strPathsOrJars[k]);
                ++k;
            }
        }
        listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        if (log.isDebugEnabled()) {
            Iterator tIter = listPaths.iterator();
            while (tIter.hasNext()) {
                log.debug("listPaths : " + tIter.next());
            }
        }
        listClasses = new ArrayList();
        listSuperClasses = new ArrayList<String>();
        int i = 0;
        while (i < superClasses.length) {
            listSuperClasses.add(superClasses[i].getName());
            ++i;
        }
        ClassFinder.findClassesInPaths(listPaths, listClasses);
        if (log.isDebugEnabled()) {
            Iterator tIter = listClasses.iterator();
            while (tIter.hasNext()) {
                log.debug("listClasses : " + tIter.next());
            }
        }
        ArrayList subClassList = ClassFinder.findAllSubclasses(listSuperClasses, listClasses, innerClasses);
        return subClassList;
    }

    private static List getClasspathMatches(String[] strPathsOrJars) {
        ArrayList<String> listPaths = null;
        StringTokenizer stPaths = null;
        String strPath = null;
        listPaths = new ArrayList<String>();
        log.debug("Classpath = " + System.getProperty("java.class.path"));
        stPaths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        if (strPathsOrJars != null) {
            strPathsOrJars = ClassFinder.fixDotDirs(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixSlashes(strPathsOrJars);
            strPathsOrJars = ClassFinder.fixEndingSlashes(strPathsOrJars);
        }
        while (stPaths.hasMoreTokens()) {
            strPath = ClassFinder.fixDotDir(stPaths.nextToken());
            strPath = ClassFinder.fixSlashes(strPath);
            strPath = ClassFinder.fixEndingSlashes(strPath);
            if (strPathsOrJars == null) {
                listPaths.add(strPath);
                continue;
            }
            int i = 0;
            while (i < strPathsOrJars.length) {
                if (log.isDebugEnabled()) {
                    log.debug("strPath(lower) : " + strPath.toLowerCase());
                    log.debug("strPathsOrJars[" + i + "] : " + strPathsOrJars[i]);
                }
                if (strPath.endsWith(strPathsOrJars[i])) {
                    log.debug("match!!!");
                    listPaths.add(strPath);
                }
                ++i;
            }
        }
        return listPaths;
    }

    private static void getAllInterfaces(Class theClass, Map hInterfaces) {
        Class<?>[] interfaces = theClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            hInterfaces.put(interfaces[i].getName(), interfaces[i]);
            ClassFinder.getAllInterfaces(interfaces[i], hInterfaces);
            ++i;
        }
    }

    private static String[] fixDotDirs(String[] paths) {
        int i = 0;
        while (i < paths.length) {
            paths[i] = ClassFinder.fixDotDir(paths[i]);
            ++i;
        }
        return paths;
    }

    private static String fixDotDir(String path) {
        if (path != null && path.equals(".")) {
            return System.getProperty("user.dir");
        }
        return path.trim();
    }

    private static String[] fixEndingSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            strNew[i] = ClassFinder.fixEndingSlashes(strings[i]);
            ++i;
        }
        return strNew;
    }

    private static String fixEndingSlashes(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
            string = ClassFinder.fixEndingSlashes(string);
        }
        return string;
    }

    private static String[] fixSlashes(String[] strings) {
        String[] strNew = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            strNew[i] = ClassFinder.fixSlashes(strings[i]);
            ++i;
        }
        return strNew;
    }

    private static String fixSlashes(String str) {
        str = str.replace('\\', '/');
        str = ClassFinder.replaceString(str, "//", "_____");
        str = ClassFinder.replaceString(str, "_____", "/");
        return str;
    }

    private static String replaceString(String s, String strToFind, String strToReplace) {
        int index;
        StringBuffer buffer = null;
        if (s.indexOf(strToFind) == -1) {
            return s;
        }
        int currentPos = 0;
        buffer = new StringBuffer();
        while ((index = s.indexOf(strToFind, currentPos)) != -1) {
            buffer.append(s.substring(currentPos, index));
            buffer.append(strToReplace);
            currentPos = index + strToFind.length();
        }
        buffer.append(s.substring(currentPos));
        return buffer.toString();
    }

    private static boolean classImplementsInterface(Class theClass, Class theInterface) {
        HashMap mapInterfaces = new HashMap();
        String strKey = null;
        ClassFinder.getAllInterfaces(theClass, mapInterfaces);
        Iterator iterInterfaces = mapInterfaces.keySet().iterator();
        while (iterInterfaces.hasNext()) {
            strKey = (String)iterInterfaces.next();
            if (mapInterfaces.get(strKey) != theInterface) continue;
            return true;
        }
        return false;
    }

    private static ArrayList findAllSubclasses(List listSuperClasses, List listAllClasses) {
        return ClassFinder.findAllSubclasses(listSuperClasses, listAllClasses, false);
    }

    private static ArrayList findAllSubclasses(List listSuperClasses, List listAllClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        ArrayList listSubClasses = null;
        String strClassName = null;
        Class<?> tempClass = null;
        listSubClasses = new ArrayList();
        iterClasses = listSuperClasses.iterator();
        while (iterClasses.hasNext()) {
            strClassName = (String)iterClasses.next();
            if (strClassName.indexOf("$") != -1 && !innerClasses) continue;
            try {
                tempClass = Class.forName(strClassName, false, Thread.currentThread().getContextClassLoader());
                ClassFinder.findAllSubclassesOneClass(tempClass, listAllClasses, listSubClasses, innerClasses);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return listSubClasses;
    }

    private static void findAllSubclassesOneClass(Class theClass, List listAllClasses, List listSubClasses) {
        ClassFinder.findAllSubclassesOneClass(theClass, listAllClasses, listSubClasses, false);
    }

    private static void findAllSubclassesOneClass(Class theClass, List listAllClasses, List listSubClasses, boolean innerClasses) {
        Iterator iterClasses = null;
        String strClassName = null;
        String strSuperClassName = null;
        Class<?> c = null;
        Object cParent = null;
        boolean bIsSubclass = false;
        strSuperClassName = theClass.getName();
        iterClasses = listAllClasses.iterator();
        while (iterClasses.hasNext()) {
            strClassName = (String)iterClasses.next();
            if (strClassName.indexOf("$") != -1 && !innerClasses) continue;
            try {
                if (strClassName == null || !(bIsSubclass = !(c = Class.forName(strClassName, false, Thread.currentThread().getContextClassLoader())).isInterface() && !Modifier.isAbstract(c.getModifiers()) ? theClass.isAssignableFrom(c) : false)) continue;
                listSubClasses.add(strClassName);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    private static String fixClassName(String strClassName) {
        strClassName = strClassName.replace('\\', '.');
        strClassName = strClassName.replace('/', '.');
        strClassName = strClassName.substring(0, strClassName.length() - 6);
        return strClassName;
    }

    private static void findClassesInOnePath(String strPath, List listClasses) throws IOException {
        File file = null;
        Object strPathName = null;
        ZipFile zipFile = null;
        Object zipEntry = null;
        Enumeration<? extends ZipEntry> entries = null;
        String strEntry = null;
        file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses);
        } else if (file.exists()) {
            zipFile = new ZipFile(file);
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                strEntry = ((Object)entries.nextElement()).toString();
                if (!strEntry.endsWith(".class")) continue;
                listClasses.add(ClassFinder.fixClassName(strEntry));
            }
        }
    }

    private static void findClassesInPaths(List listPaths, List listClasses) throws IOException {
        Iterator iterPaths = listPaths.iterator();
        while (iterPaths.hasNext()) {
            ClassFinder.findClassesInOnePath((String)iterPaths.next(), listClasses);
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, List listClasses) throws IOException {
        File file = null;
        String[] list = dir.list();
        int i = 0;
        while (i < list.length) {
            file = new File(dir, list[i]);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses);
            } else if (file.exists() && file.length() != 0L && list[i].endsWith(".class")) {
                listClasses.add(file.getPath().substring(strPathElement.length() + 1, file.getPath().lastIndexOf(".")).replace(File.separator.charAt(0), '.'));
            }
            ++i;
        }
    }
}

