/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.protocol.java.config.JavaConfig;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JavaConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.java");
    private static final String CLASSNAMECOMBO = "classnamecombo";
    private JComboBox classnameCombo;
    private boolean displayName = true;
    private ArgumentsPanel argsPanel;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$java$sampler$JavaSampler;

    public JavaConfigGui() {
        this(true);
    }

    public JavaConfigGui(boolean displayNameField) {
        this.displayName = displayNameField;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"java_request_defaults");
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        JPanel classnameRequestPanel = new JPanel(new BorderLayout(0, 5));
        classnameRequestPanel.add((Component)this.createClassnamePanel(), "North");
        classnameRequestPanel.add((Component)this.createParameterPanel(), "Center");
        this.add(classnameRequestPanel, "Center");
    }

    private JPanel createClassnamePanel() {
        List possibleClasses = null;
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient == null ? (class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient = JavaConfigGui.class$("org.apache.jmeter.protocol.java.sampler.JavaSamplerClient")) : class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient});
            possibleClasses.remove((class$org$apache$jmeter$protocol$java$sampler$JavaSampler == null ? (class$org$apache$jmeter$protocol$java$sampler$JavaSampler = JavaConfigGui.class$("org.apache.jmeter.protocol.java.sampler.JavaSampler")) : class$org$apache$jmeter$protocol$java$sampler$JavaSampler).getName() + "$ErrorSamplerClient");
        }
        catch (Exception e) {
            log.debug("Exception getting interfaces.", (Throwable)e);
        }
        JLabel label = new JLabel(JMeterUtils.getResString((String)"protocol_java_classname"));
        this.classnameCombo = new JComboBox<Object>(possibleClasses.toArray());
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setName(CLASSNAMECOMBO);
        this.classnameCombo.setEditable(false);
        label.setLabelFor(this.classnameCombo);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.classnameCombo);
        return panel;
    }

    public void actionPerformed(ActionEvent evt) {
        block7: {
            if (evt.getSource() != this.classnameCombo) break block7;
            String className = ((String)this.classnameCombo.getSelectedItem()).trim();
            try {
                JavaSamplerClient client = (JavaSamplerClient)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                Arguments currArgs = new Arguments();
                this.argsPanel.modifyTestElement((TestElement)currArgs);
                Map currArgsMap = currArgs.getArgumentsAsMap();
                Arguments newArgs = new Arguments();
                Arguments testParams = null;
                try {
                    testParams = client.getDefaultParameters();
                }
                catch (AbstractMethodError e) {
                    log.warn("JavaSamplerClient doesn't implement getDefaultParameters.  Default parameters won't be shown.  Please update your client class: " + className);
                }
                if (testParams != null) {
                    PropertyIterator i = testParams.getArguments().iterator();
                    while (i.hasNext()) {
                        String newVal;
                        Argument arg = (Argument)i.next().getObjectValue();
                        String name = arg.getName();
                        String value = arg.getValue();
                        if (currArgsMap.containsKey(name) && (newVal = (String)currArgsMap.get(name)) != null && newVal.toString().length() > 0) {
                            value = newVal;
                        }
                        newArgs.addArgument(name, value);
                    }
                }
                this.argsPanel.configure((TestElement)newArgs);
            }
            catch (Exception e) {
                log.error("Error getting argument list for " + className, (Throwable)e);
            }
        }
    }

    private JPanel createParameterPanel() {
        this.argsPanel = new ArgumentsPanel();
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments").getObjectValue()));
        this.classnameCombo.setSelectedItem(config.getPropertyAsString("classname"));
    }

    public TestElement createTestElement() {
        JavaConfig config = new JavaConfig();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        this.configureTestElement(config);
        ((JavaConfig)config).setArguments((Arguments)this.argsPanel.createTestElement());
        ((JavaConfig)config).setClassname(this.classnameCombo.getSelectedItem().toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

