/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.test;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;

public class JavaTest
extends AbstractJavaSamplerClient
implements Serializable {
    private long sleepTime;
    public static final long DEFAULT_SLEEP_TIME = 100L;
    private static final String SLEEP_NAME = "Sleep_Time";
    private long sleepMask;
    public static final long DEFAULT_SLEEP_MASK = 255L;
    private static final String DEFAULT_MASK_STRING = "0x" + Long.toHexString(255L).toUpperCase();
    private static final String MASK_NAME = "Sleep_Mask";
    private String label;
    private static final String LABEL_DEFAULT = "JavaTest";
    private static final String LABEL_NAME = "Label";
    private String responseMessage;
    private static final String RESPONSE_MESSAGE_DEFAULT = "";
    private static final String RESPONSE_MESSAGE_NAME = "ResponseMessage";
    private String responseCode;
    private static final String RESPONSE_CODE_DEFAULT = "";
    private static final String RESPONSE_CODE_NAME = "ResponseCode";
    private String samplerData;
    private static final String SAMPLER_DATA_DEFAULT = "";
    private static final String SAMPLER_DATA_NAME = "SamplerData";
    private String resultData;
    private static final String RESULT_DATA_DEFAULT = "";
    private static final String RESULT_DATA_NAME = "ResultData";
    private boolean success;
    private static final String SUCCESS_DEFAULT = "OK";
    private static final String SUCCESS_NAME = "Status";

    public JavaTest() {
        this.getLogger().debug(this.whoAmI() + "\tConstruct");
    }

    private void setupValues(JavaSamplerContext context) {
        this.sleepTime = context.getLongParameter(MASK_NAME, 100L);
        this.sleepMask = context.getLongParameter(SLEEP_NAME, 255L);
        this.responseMessage = context.getParameter(RESPONSE_MESSAGE_NAME, "");
        this.responseCode = context.getParameter(RESPONSE_CODE_NAME, "");
        this.success = context.getParameter(SUCCESS_NAME, SUCCESS_DEFAULT).equalsIgnoreCase(SUCCESS_DEFAULT);
        this.label = context.getParameter(LABEL_NAME, LABEL_DEFAULT);
        this.samplerData = context.getParameter(SAMPLER_DATA_NAME, "");
        this.resultData = context.getParameter(RESULT_DATA_NAME, "");
    }

    public void setupTest(JavaSamplerContext context) {
        this.getLogger().debug(this.whoAmI() + "\tsetupTest()");
        this.listParameters(context);
    }

    public Arguments getDefaultParameters() {
        Arguments params = new Arguments();
        params.addArgument(SLEEP_NAME, String.valueOf(100L));
        params.addArgument(MASK_NAME, DEFAULT_MASK_STRING);
        params.addArgument(LABEL_NAME, LABEL_DEFAULT);
        params.addArgument(RESPONSE_CODE_NAME, "");
        params.addArgument(RESPONSE_MESSAGE_NAME, "");
        params.addArgument(SUCCESS_NAME, SUCCESS_DEFAULT);
        params.addArgument(SAMPLER_DATA_NAME, "");
        params.addArgument(RESULT_DATA_NAME, "");
        return params;
    }

    public SampleResult runTest(JavaSamplerContext context) {
        this.setupValues(context);
        SampleResult results = new SampleResult();
        try {
            long start = System.currentTimeMillis();
            results.setResponseCode(this.responseCode);
            results.setResponseMessage(this.responseMessage);
            if (this.samplerData != null && this.samplerData.length() > 0) {
                results.setSamplerData(this.samplerData);
            }
            if (this.resultData != null && this.resultData.length() > 0) {
                results.setResponseData(this.resultData.getBytes());
                results.setDataType("text");
            }
            long ct = start % this.getSleepMask();
            Thread.sleep(this.getSleepTime() + ct);
            long end = System.currentTimeMillis();
            results.setTime(end - start);
            results.setSuccessful(this.success);
            results.setSampleLabel(this.label);
        }
        catch (Exception e) {
            this.getLogger().error("JavaTest: error during sample", (Throwable)e);
            results.setSuccessful(false);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this.whoAmI() + "\trunTest()" + "\tTime:\t" + results.getTime());
            this.listParameters(context);
        }
        return results;
    }

    public void teardownTest(JavaSamplerContext context) {
        this.getLogger().debug(this.whoAmI() + "\tteardownTest()");
        this.listParameters(context);
    }

    private void listParameters(JavaSamplerContext context) {
        if (this.getLogger().isDebugEnabled()) {
            Iterator argsIt = context.getParameterNamesIterator();
            while (argsIt.hasNext()) {
                String name = (String)argsIt.next();
                this.getLogger().debug(name + "=" + context.getParameter(name));
            }
        }
    }

    private String whoAmI() {
        StringBuffer sb = new StringBuffer();
        sb.append(Thread.currentThread().toString());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    private long getSleepTime() {
        return this.sleepTime;
    }

    private long getSleepMask() {
        return this.sleepMask;
    }
}

