/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.LoginConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class DbConfigGui
extends AbstractConfigGui {
    private static final String LOGIN_ELEMENT = "DbConfigGui.login_element";
    private static String PROTOCOL = "protocol";
    private static String URL = "url";
    private static String DRIVER = "driver";
    private JTextField urlField = new JTextField(20);
    private JTextField driverField = new JTextField(20);
    private boolean displayName;
    private LoginConfigGui loginGui;

    public DbConfigGui() {
        this(true);
    }

    public DbConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_login_title");
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        element.clear();
        this.configureTestElement(element);
        element.setProperty("JDBCSampler.url", this.urlField.getText());
        element.setProperty("JDBCSampler.driver", this.driverField.getText());
        element.addTestElement(this.loginGui.createTestElement());
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.urlField.setText(element.getPropertyAsString("JDBCSampler.url"));
        this.driverField.setText(element.getPropertyAsString("JDBCSampler.driver"));
        this.loginGui.configure(element);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        VerticalPanel urlJDBCPanel = new VerticalPanel();
        urlJDBCPanel.setBorder((Border)BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_url_jdbc_props")));
        urlJDBCPanel.add((Component)this.getUrlPanel());
        urlJDBCPanel.add((Component)this.getDriverPanel());
        mainPanel.add((Component)urlJDBCPanel);
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
        this.loginGui = new LoginConfigGui(false);
        loginPanel.add((Component)this.loginGui, "North");
        mainPanel.add((Component)loginPanel);
        this.add((Component)mainPanel, "Center");
    }

    private JPanel getDriverPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"database_driver_class"));
        label.setLabelFor(this.driverField);
        this.driverField.setName(DRIVER);
        panel.add((Component)label, "West");
        panel.add((Component)this.driverField, "Center");
        return panel;
    }

    private JPanel getUrlPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"database_url"));
        label.setLabelFor(this.urlField);
        this.urlField.setName(URL);
        panel.add((Component)label, "West");
        panel.add((Component)this.urlField, "Center");
        return panel;
    }
}

