/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class PoolConfigGui
extends AbstractConfigGui
implements FocusListener {
    private static String CONNECTIONS = "connections";
    private static String MAXUSE = "maxuse";
    private static String DEFAULT_MAX_USE = "50";
    private static String DEFAULT_NUM_CONNECTIONS = "1";
    private JTextField connField;
    private JTextField maxUseField;
    private boolean displayName;

    public PoolConfigGui() {
        this(true);
    }

    public PoolConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.connField.setText(element.getProperty(JDBCSampler.CONNECTIONS).toString());
        this.maxUseField.setText(element.getProperty(JDBCSampler.MAXUSE).toString());
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty(JDBCSampler.CONNECTIONS, this.connField.getText());
        element.setProperty(JDBCSampler.MAXUSE, this.maxUseField.getText());
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_conn_pool_title");
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        block7: {
            String name;
            block6: {
                name = e.getComponent().getName();
                if (!name.equals(CONNECTIONS)) break block6;
                try {
                    Integer.parseInt(this.connField.getText());
                }
                catch (NumberFormatException nfe) {
                    if (this.connField.getText().length() > 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                    }
                    this.connField.setText(DEFAULT_NUM_CONNECTIONS);
                }
                break block7;
            }
            if (!name.equals(MAXUSE)) break block7;
            try {
                Integer.parseInt(this.maxUseField.getText());
            }
            catch (NumberFormatException nfe) {
                if (this.maxUseField.getText().length() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                }
                this.maxUseField.setText(DEFAULT_NUM_CONNECTIONS);
            }
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel poolPanel = new VerticalPanel();
        poolPanel.setBorder((Border)BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"database_conn_pool_props")));
        poolPanel.add((Component)this.createConnPanel());
        poolPanel.add((Component)this.createMaxUsePanel());
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Component)poolPanel);
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createConnPanel() {
        this.connField = new JTextField(DEFAULT_NUM_CONNECTIONS, 5);
        this.connField.setName(CONNECTIONS);
        this.connField.addFocusListener(this);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"database_conn_pool_size"));
        label.setLabelFor(this.connField);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connField, "Center");
        return panel;
    }

    private JPanel createMaxUsePanel() {
        this.maxUseField = new JTextField(DEFAULT_MAX_USE, 5);
        this.maxUseField.setName(MAXUSE);
        this.maxUseField.addFocusListener(this);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"database_conn_pool_max_usage"));
        label.setLabelFor(this.maxUseField);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.maxUseField, "Center");
        return panel;
    }
}

