/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class SqlConfigGui
extends AbstractConfigGui {
    private JTextArea sqlField;
    private boolean displayName;

    public SqlConfigGui() {
        this(true);
    }

    public SqlConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_sql_query_title");
    }

    public void configure(TestElement element) {
        this.sqlField.setText(element.getProperty("JDBCSampler.query").toString());
        super.configure(element);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        String text = this.sqlField.getText();
        text = text.replace('\n', ' ');
        element.setProperty("JDBCSampler.query", text);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        JPanel panel = this.createSqlPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createSqlPanel() {
        this.sqlField = new JTextArea();
        this.sqlField.setRows(4);
        this.sqlField.setLineWrap(true);
        this.sqlField.setWrapStyleWord(true);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"database_sql_query_string"));
        label.setLabelFor(this.sqlField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(this.sqlField), "Center");
        return panel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

