/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.jdbc.config.gui.DbConfigGui;
import org.apache.jmeter.protocol.jdbc.config.gui.PoolConfigGui;
import org.apache.jmeter.protocol.jdbc.config.gui.SqlConfigGui;
import org.apache.jmeter.protocol.jdbc.sampler.JDBCSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class JdbcTestSampleGui
extends AbstractSamplerGui {
    private PoolConfigGui poolGui;
    private DbConfigGui dbGui;
    private SqlConfigGui sqlGui;

    public JdbcTestSampleGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.dbGui.configure(element);
        this.poolGui.configure(element);
        this.sqlGui.configure(element);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"database_testing_title");
    }

    public TestElement createTestElement() {
        JDBCSampler sampler = new JDBCSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        sampler.addTestElement(this.dbGui.createTestElement());
        sampler.addTestElement(this.poolGui.createTestElement());
        sampler.addTestElement(this.sqlGui.createTestElement());
        this.configureTestElement(sampler);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout(0, 5));
        VerticalPanel connPanel = new VerticalPanel();
        this.dbGui = new DbConfigGui(false);
        connPanel.add((Component)((Object)this.dbGui));
        this.poolGui = new PoolConfigGui(false);
        connPanel.add((Component)((Object)this.poolGui));
        mainPanel.add((Component)connPanel, "North");
        this.sqlGui = new SqlConfigGui(false);
        mainPanel.add((Component)((Object)this.sqlGui), "Center");
        this.add(mainPanel, "Center");
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

