/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.jmeter.protocol.jdbc.util.DBConnectionManager;
import org.apache.jmeter.protocol.jdbc.util.DBKey;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConnectionObject
implements Runnable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.jdbc");
    Connection con;
    DBKey key;
    int useCount;
    int maxUsage;
    long lastAccessed;
    boolean inUse;
    boolean inMaintenance;
    DBConnectionManager manager;
    Thread reset;
    static long accessInterval = 180000L;

    public ConnectionObject(DBConnectionManager man, DBKey k) {
        this.key = k;
        this.manager = man;
        this.reset = new Thread(this);
        this.useCount = 0;
        this.lastAccessed = System.currentTimeMillis();
        this.inMaintenance = true;
        this.inUse = false;
        this.con = null;
        this.maxUsage = this.key.getMaxUsage();
        this.reset.start();
    }

    public boolean getInMaintenance() {
        return this.inMaintenance;
    }

    public void setInMaintenance(boolean b) {
        this.inMaintenance = b;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void close() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.con = null;
    }

    public void update() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public synchronized Connection grab() {
        Connection c;
        block7: {
            c = null;
            if (!this.inUse && !this.inMaintenance) {
                if (this.con != null) {
                    try {
                        if (this.con.isClosed()) {
                            this.inMaintenance = true;
                            this.reset.start();
                            break block7;
                        }
                        if (System.currentTimeMillis() - this.lastAccessed > accessInterval) {
                            this.inMaintenance = true;
                            this.reset.start();
                            break block7;
                        }
                        this.inUse = true;
                        c = this.con;
                    }
                    catch (SQLException e) {}
                } else {
                    this.inMaintenance = true;
                    this.reset.start();
                }
            }
        }
        return c;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void run() {
        boolean set = true;
        while (set) {
            try {
                this.reset();
                set = false;
            }
            catch (SQLException e) {
                log.error("ConnectionObject: url = " + this.key.getUrl(), (Throwable)e);
            }
        }
        this.reset = new Thread(this);
    }

    public void reset() throws SQLException {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.con = null;
        }
        this.con = this.manager.newConnection(this.key);
        this.useCount = 0;
        this.lastAccessed = System.currentTimeMillis();
        this.inUse = false;
        this.inMaintenance = false;
    }

    public void release() {
        ++this.useCount;
        try {
            if (this.con != null) {
                if (System.currentTimeMillis() - this.lastAccessed > accessInterval) {
                    this.inMaintenance = true;
                    this.reset.start();
                } else if (this.useCount >= this.maxUsage) {
                    this.inMaintenance = true;
                    this.reset.start();
                } else if (this.con.isClosed()) {
                    this.inMaintenance = true;
                    this.reset.start();
                }
            } else {
                this.inMaintenance = true;
                this.reset.start();
            }
        }
        catch (SQLException e) {
            this.inMaintenance = true;
            this.reset.start();
        }
        this.inUse = false;
        this.lastAccessed = System.currentTimeMillis();
    }

    public Connection getCon() {
        return this.con;
    }
}

