/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit.protocol.http.config;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class UrlConfigTest
extends TestCase {
    HTTPSampler config;
    HTTPSampler defaultConfig;
    HTTPSampler partialConfig;

    public UrlConfigTest(String name) {
        super(name);
    }

    protected void setUp() {
        Arguments args = new Arguments();
        args.addArgument("username", "mstover");
        args.addArgument("password", "pass");
        args.addArgument("action", "login");
        this.config = new HTTPSampler();
        this.config.setName("Full Config");
        this.config.setProperty("HTTPSampler.domain", "www.lazer.com");
        this.config.setProperty("HTTPSampler.path", "login.jsp");
        this.config.setProperty("HTTPSampler.method", "POST");
        this.config.setProperty((JMeterProperty)new TestElementProperty("HTTPsampler.Arguments", (TestElement)args));
        this.defaultConfig = new HTTPSampler();
        this.defaultConfig.setName("default");
        this.defaultConfig.setProperty("HTTPSampler.domain", "www.xerox.com");
        this.defaultConfig.setProperty("HTTPSampler.path", "default.html");
        this.partialConfig = new HTTPSampler();
        this.partialConfig.setProperty("HTTPSampler.path", "main.jsp");
        this.partialConfig.setProperty("HTTPSampler.method", "GET");
    }

    public void testSimpleConfig() {
        Assert.assertTrue((boolean)this.config.getName().equals("Full Config"));
        Assert.assertEquals((Object)this.config.getDomain(), (Object)"www.lazer.com");
    }

    public void testOverRide() {
        Assert.assertTrue((boolean)new NullProperty().equals((Object)this.partialConfig.getProperty("HTTPSampler.domain")));
        this.partialConfig.addTestElement((TestElement)this.defaultConfig);
        Assert.assertEquals((Object)this.partialConfig.getPropertyAsString("HTTPSampler.domain"), (Object)"www.xerox.com");
        Assert.assertEquals((Object)this.partialConfig.getPropertyAsString("HTTPSampler.path"), (Object)"main.jsp");
    }

    public static void main(String[] args) {
    }
}

