/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.protocol.http.modifier.AnchorModifier;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContextService;

public class HtmlParserTester
extends TestCase {
    AnchorModifier parser = new AnchorModifier();

    public HtmlParserTester(String name) {
        super(name);
    }

    public void testSimpleParse() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*/index\\.html");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"index.html\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        result.setSamplerData(context.toString());
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        Assert.assertEquals((Object)"http://www.apache.org/subdir/index.html", (Object)config.getUrl().toString());
    }

    public void testSimpleParse2() throws Exception {
        HTTPSampler config = this.makeUrlConfig("/index\\.html");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"/index.html\">Goto index page</a>hfdfjiudfjdfjkjfkdjf<b>bold text</b><a href=lowerdir/index.html>lower</a></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        String newUrl = config.getUrl().toString();
        Assert.assertTrue(("http://www.apache.org/index.html".equals(newUrl) || "http://www.apache.org/subdir/lowerdir/index.html".equals(newUrl) ? 1 : 0) != 0);
    }

    public void testSimpleParse3() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*index.*");
        config.getArguments().addArgument("param1", "value1");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"/home/index.html?param1=value1\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        String newUrl = config.getUrl().toString();
        Assert.assertEquals((Object)"http://www.apache.org/home/index.html?param1=value1", (Object)newUrl);
    }

    public void testSimpleParse4() throws Exception {
        HTTPSampler config = this.makeUrlConfig("/subdir/index\\..*");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><A HREF=\"index.html\">Goto index page</A></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        String newUrl = config.getUrl().toString();
        Assert.assertEquals((Object)"http://www.apache.org/subdir/index.html", (Object)newUrl);
    }

    public void testSimpleParse5() throws Exception {
        HTTPSampler config = this.makeUrlConfig("/subdir/index\\.h.*");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/one/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"../index.html\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        String newUrl = config.getUrl().toString();
        Assert.assertEquals((Object)"http://www.apache.org/subdir/index.html", (Object)newUrl);
    }

    public void testFailSimpleParse1() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*index.*?param2=.+1");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"/home/index.html?param1=value1\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        String newUrl = config.getUrl().toString();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        Assert.assertEquals((Object)newUrl, (Object)config.getUrl().toString());
    }

    public void testFailSimpleParse3() throws Exception {
        HTTPSampler config = this.makeUrlConfig("/home/index.html");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"/home/index.html?param1=value1\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        String newUrl = config.getUrl().toString();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        Assert.assertEquals((Object)(newUrl + "?param1=value1"), (Object)config.getUrl().toString());
    }

    public void testFailSimpleParse2() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*login\\.html");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><a href=\"/home/index.html?param1=value1\">Goto index page</a></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        String newUrl = config.getUrl().toString();
        Assert.assertTrue((!"http://www.apache.org/home/index.html?param1=value1".equals(newUrl) ? 1 : 0) != 0);
        Assert.assertEquals((Object)config.getUrl().toString(), (Object)newUrl);
    }

    public void testSimpleFormParse() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*index.html");
        config.addArgument("test", "g.*");
        config.setMethod("POST");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><form action=\"index.html\" method=\"POST\"><input type=\"checkbox\" name=\"test\" value=\"goto\">Goto index page</form></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        Assert.assertEquals((Object)"http://www.apache.org/subdir/index.html", (Object)config.getUrl().toString());
        Assert.assertEquals((Object)"test=goto", (Object)config.getQueryString());
    }

    public void testBadCharParse() throws Exception {
        HTTPSampler config = this.makeUrlConfig(".*index.html");
        config.addArgument("te$st", "g.*");
        config.setMethod("POST");
        HTTPSampler context = this.makeContext("http://www.apache.org/subdir/previous.html");
        String responseText = "<html><head><title>Test page</title></head><body><form action=\"index.html\" method=\"POST\"><input type=\"checkbox\" name=\"te$st\" value=\"goto\">Goto index page</form></body></html>";
        SampleResult result = new SampleResult();
        result.setResponseData(responseText.getBytes());
        result.setSampleLabel(context.toString());
        JMeterContextService.getContext().setCurrentSampler((Sampler)context);
        JMeterContextService.getContext().setCurrentSampler((Sampler)config);
        JMeterContextService.getContext().setPreviousResult(result);
        this.parser.process();
        Assert.assertEquals((Object)"http://www.apache.org/subdir/index.html", (Object)config.getUrl().toString());
        Assert.assertEquals((Object)"te%24st=goto", (Object)config.getQueryString());
    }

    private HTTPSampler makeContext(String url) throws MalformedURLException {
        URL u = new URL(url);
        HTTPSampler context = new HTTPSampler();
        context.setDomain(u.getHost());
        context.setPath(u.getPath());
        context.setPort(u.getPort());
        context.setProtocol(u.getProtocol());
        context.parseArguments(u.getQuery());
        return context;
    }

    private HTTPSampler makeUrlConfig(String path) {
        HTTPSampler config = new HTTPSampler();
        config.setDomain("www.apache.org");
        config.setMethod("GET");
        config.setPath(path);
        config.setPort(80);
        config.setProtocol("http");
        return config;
    }
}

