/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config;

import java.io.Serializable;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jorphan.util.JOrphanUtils;

public class MultipartUrlConfig
implements Serializable {
    public static String MULTIPART_FORM = "multipart/form-data";
    private static String BOUNDARY = "boundary";
    private String boundary;
    private String filename;
    private String fileField;
    private String mimetype;
    private Arguments args = new Arguments();

    public MultipartUrlConfig() {
    }

    public MultipartUrlConfig(String boundary) {
        this();
        this.boundary = boundary;
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public Arguments getArguments() {
        return this.args;
    }

    public void setFileFieldName(String name) {
        this.fileField = name;
    }

    public String getFileFieldName() {
        return this.fileField;
    }

    public void setMimeType(String type) {
        this.mimetype = type;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void addArgument(String name, String value) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public void addEncodedArgument(String name, String value) {
        Arguments args = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, true);
        if (arg.getName().equals(arg.getEncodedName()) && arg.getValue().equals(arg.getEncodedValue())) {
            arg.setAlwaysEncoded(false);
        }
        args.addArgument((Argument)arg);
    }

    public void parseArguments(String queryString) {
        String[] parts = JOrphanUtils.split((String)queryString, (String)("--" + this.getBoundary()));
        int i = 0;
        while (i < parts.length) {
            String name;
            int index;
            if (parts[i].indexOf("filename=") > -1) {
                index = parts[i].indexOf("name=\"") + 6;
                name = parts[i].substring(index, parts[i].indexOf("\"", index));
                index = parts[i].indexOf("filename=\"") + 10;
                String filename = parts[i].substring(index, parts[i].indexOf("\"", index));
                index = parts[i].indexOf("\n", index);
                index = parts[i].indexOf(":", index) + 1;
                String mimetype = parts[i].substring(index, parts[i].indexOf("\n", index)).trim();
                this.setFileFieldName(name);
                this.setFilename(filename);
                this.setMimeType(mimetype);
            } else if (parts[i].indexOf("name=") > -1) {
                index = parts[i].indexOf("name=\"") + 6;
                name = parts[i].substring(index, parts[i].indexOf("\"", index));
                index = parts[i].indexOf("\n", index) + 2;
                String value = parts[i].substring(index).trim();
                this.addEncodedArgument(name, value);
            }
            ++i;
        }
    }
}

