/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class HttpDefaultsGui
extends AbstractConfigGui {
    JLabeledTextField protocol;
    JLabeledTextField domain;
    JLabeledTextField path;
    JLabeledTextField port;
    HTTPArgumentsPanel argPanel;

    public HttpDefaultsGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"url_config_title");
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        super.configureTestElement(config);
        config.setProperty("HTTPSampler.protocol", this.protocol.getText());
        config.setProperty("HTTPSampler.domain", this.domain.getText());
        config.setProperty("HTTPSampler.path", this.path.getText());
        config.setProperty((JMeterProperty)new TestElementProperty("HTTPsampler.Arguments", this.argPanel.createTestElement()));
        config.setProperty("HTTPSampler.port", this.port.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.protocol.setText(el.getPropertyAsString("HTTPSampler.protocol"));
        this.domain.setText(el.getPropertyAsString("HTTPSampler.domain"));
        this.path.setText(el.getPropertyAsString("HTTPSampler.path"));
        this.port.setText(el.getPropertyAsString("HTTPSampler.port"));
        this.argPanel.configure((TestElement)el.getProperty("HTTPsampler.Arguments").getObjectValue());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        Box mainPanel = Box.createVerticalBox();
        VerticalPanel urlPanel = new VerticalPanel();
        this.protocol = new JLabeledTextField(JMeterUtils.getResString((String)"url_config_protocol"));
        urlPanel.add((Component)this.protocol);
        this.domain = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_domain"));
        urlPanel.add((Component)this.domain);
        this.path = new JLabeledTextField(JMeterUtils.getResString((String)"path"));
        urlPanel.add((Component)this.path);
        this.port = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_port"));
        urlPanel.add((Component)this.port);
        mainPanel.add((Component)urlPanel);
        this.argPanel = new HTTPArgumentsPanel();
        mainPanel.add((Component)((Object)this.argPanel));
        this.add(mainPanel, "Center");
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

