/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class MultipartUrlConfigGui
extends UrlConfigGui
implements ActionListener {
    private JTextField filenameField;
    private JTextField paramNameField;
    private JTextField mimetypeField;
    private static String FILENAME = "filename";
    private static String BROWSE = "browse";
    private static String PARAMNAME = "paramname";
    private static String MIMETYPE = "mimetype";

    public TestElement createTestElement() {
        TestElement ce = super.createTestElement();
        this.configureTestElement(ce);
        ce.setProperty("HTTPSampler.mimetype", this.mimetypeField.getText());
        ce.setProperty("HTTPSampler.FILE_NAME", this.filenameField.getText());
        ce.setProperty("HTTPSampler.FILE_FIELD", this.paramNameField.getText());
        return ce;
    }

    public void configureSampler(HTTPSampler sampler) {
        sampler.setMimetype(this.mimetypeField.getText());
        sampler.setFileField(this.paramNameField.getText());
        sampler.setFilename(this.filenameField.getText());
        super.configureSampler(sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.mimetypeField.setText(el.getPropertyAsString("HTTPSampler.mimetype"));
        this.filenameField.setText(el.getPropertyAsString("HTTPSampler.FILE_NAME"));
        this.paramNameField.setText(el.getPropertyAsString("HTTPSampler.FILE_FIELD"));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"url_multipart_config_title");
    }

    public void updateGui() {
    }

    public void actionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        if (name.equals(BROWSE)) {
            JFileChooser chooser = FileDialoger.promptToOpenFile();
            if (chooser == null) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file != null) {
                this.filenameField.setText(file.getPath());
            }
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        VerticalPanel webServerPanel = new VerticalPanel();
        webServerPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.getDomainPanel());
        webServerPanel.add((Component)this.getPortPanel());
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BoxLayout(webRequestPanel, 1));
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        webRequestPanel.add(this.getProtocolAndMethodPanel());
        webRequestPanel.add(this.getPathPanel());
        webRequestPanel.add(this.getParameterPanel());
        webRequestPanel.add(this.getFilePanel());
        this.add((Component)webServerPanel, "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected JPanel getFilePanel() {
        VerticalPanel filePanel = new VerticalPanel();
        filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"send_file")));
        filePanel.add(this.createFilenamePanel());
        filePanel.add(this.createFileParamNamePanel());
        filePanel.add(this.createFileMimeTypePanel());
        return filePanel;
    }

    private JPanel createFileMimeTypePanel() {
        this.mimetypeField = new JTextField(15);
        this.mimetypeField.setName(MIMETYPE);
        JLabel mimetypeLabel = new JLabel(JMeterUtils.getResString((String)"send_file_mime_label"));
        mimetypeLabel.setLabelFor(this.mimetypeField);
        JPanel mimePanel = new JPanel(new BorderLayout(5, 0));
        mimePanel.add((Component)mimetypeLabel, "West");
        mimePanel.add((Component)this.mimetypeField, "Center");
        return mimePanel;
    }

    private JPanel createFileParamNamePanel() {
        this.paramNameField = new JTextField(15);
        this.paramNameField.setName(PARAMNAME);
        JLabel paramNameLabel = new JLabel(JMeterUtils.getResString((String)"send_file_param_name_label"));
        paramNameLabel.setLabelFor(this.paramNameField);
        JPanel paramNamePanel = new JPanel(new BorderLayout(5, 0));
        paramNamePanel.add((Component)paramNameLabel, "West");
        paramNamePanel.add((Component)this.paramNameField, "Center");
        return paramNamePanel;
    }

    private JPanel createFilenamePanel() {
        this.filenameField = new JTextField(15);
        this.filenameField.setName(FILENAME);
        JLabel filenameLabel = new JLabel(JMeterUtils.getResString((String)"send_file_filename_label"));
        filenameLabel.setLabelFor(this.filenameField);
        JButton browseFileButton = new JButton(JMeterUtils.getResString((String)"send_file_browse"));
        browseFileButton.setActionCommand(BROWSE);
        browseFileButton.addActionListener(this);
        JPanel filenamePanel = new JPanel(new BorderLayout(5, 0));
        filenamePanel.add((Component)filenameLabel, "West");
        filenamePanel.add((Component)this.filenameField, "Center");
        filenamePanel.add((Component)browseFileButton, "East");
        return filenamePanel;
    }

    public void clear() {
        super.clear();
        this.filenameField.setText("");
        this.mimetypeField.setText("");
        this.paramNameField.setText("");
    }
}

