/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;

public class UrlConfigGui
extends JPanel {
    protected HTTPArgumentsPanel argsPanel;
    private static String DOMAIN = "domain";
    private static String PORT = "port";
    private static String PROTOCOL = "protocol";
    private static String PATH = "path";
    private static String FOLLOW_REDIRECTS = "follow_redirects";
    private static String USE_KEEPALIVE = "use_keepalive";
    private static String POST = "post";
    private static String GET = "get";
    private static String SEND_PARAM = "sendparam";
    private JTextField domain;
    private JTextField port;
    private JTextField protocol;
    private JTextField path;
    private JCheckBox followRedirects;
    private JCheckBox useKeepAlive;
    private JRadioButton post;
    private JRadioButton get;

    public UrlConfigGui() {
        this.init();
    }

    protected void configureTestElement(TestElement mc) {
        mc.setProperty("TestElement.name", this.getName());
        mc.setProperty("TestElement.gui_class", this.getClass().getName());
        mc.setProperty("TestElement.test_class", mc.getClass().getName());
    }

    public void clear() {
        this.domain.setText("");
        this.followRedirects.setSelected(true);
        this.get.setSelected(true);
        this.path.setText("");
        this.port.setText("");
        this.protocol.setText("");
        this.useKeepAlive.setSelected(true);
        this.argsPanel.clear();
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.configureTestElement((TestElement)element);
        Arguments args = (Arguments)this.argsPanel.createTestElement();
        HTTPArgument.convertArgumentsToHTTP(args);
        element.setProperty((JMeterProperty)new TestElementProperty("HTTPsampler.Arguments", (TestElement)args));
        element.setProperty("HTTPSampler.domain", this.domain.getText());
        element.setProperty("HTTPSampler.port", this.port.getText());
        element.setProperty("HTTPSampler.protocol", this.protocol.getText());
        element.setProperty("HTTPSampler.method", this.post.isSelected() ? "POST" : "GET");
        element.setProperty("HTTPSampler.path", this.path.getText());
        element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.follow_redirects", this.followRedirects.isSelected()));
        element.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.use_keepalive", this.useKeepAlive.isSelected()));
        return element;
    }

    public void configureSampler(HTTPSampler sampler) {
        sampler.setArguments((Arguments)this.argsPanel.createTestElement());
        sampler.setDomain(this.domain.getText());
        sampler.setProtocol(this.protocol.getText());
        sampler.setPath(this.path.getText());
        sampler.setFollowRedirects(this.followRedirects.isSelected());
        sampler.setUseKeepAlive(this.useKeepAlive.isSelected());
        if (this.port.getText().length() > 0) {
            sampler.setPort(Integer.parseInt(this.port.getText()));
        }
        sampler.setMethod(this.post.isSelected() ? "POST" : "GET");
    }

    public void configure(TestElement el) {
        this.setName(el.getPropertyAsString("TestElement.name"));
        this.argsPanel.configure((TestElement)el.getProperty("HTTPsampler.Arguments").getObjectValue());
        this.domain.setText(el.getPropertyAsString("HTTPSampler.domain"));
        String portString = el.getPropertyAsString("HTTPSampler.port");
        if (portString.equals("0")) {
            this.port.setText("");
        } else {
            this.port.setText(portString);
        }
        this.protocol.setText(el.getPropertyAsString("HTTPSampler.protocol"));
        if ("POST".equals(el.getPropertyAsString("HTTPSampler.method"))) {
            this.post.setSelected(true);
            this.get.setSelected(false);
        } else {
            this.get.setSelected(true);
            this.post.setSelected(false);
        }
        this.path.setText(el.getPropertyAsString("HTTPSampler.path"));
        this.followRedirects.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.follow_redirects"));
        this.useKeepAlive.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.use_keepalive"));
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel webServerPanel = new JPanel();
        webServerPanel.setLayout(new BorderLayout());
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.getDomainPanel(), "North");
        webServerPanel.add((Component)this.getPortPanel(), "West");
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_request")));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.getProtocolAndMethodPanel(), "North");
        northPanel.add(this.getPathPanel(), "South");
        webServerPanel.add((Component)northPanel, "South");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        this.add((Component)webServerPanel, "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected JPanel getPortPanel() {
        this.port = new JTextField(6);
        this.port.setName(PORT);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.port);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.port, "Center");
        return panel;
    }

    protected JPanel getDomainPanel() {
        this.domain = new JTextField(20);
        this.domain.setName(DOMAIN);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.domain);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.domain, "Center");
        return panel;
    }

    protected Component getPathPanel() {
        this.path = new JTextField(15);
        this.path.setName(PATH);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"path"));
        label.setLabelFor(this.path);
        this.followRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.followRedirects.setName(FOLLOW_REDIRECTS);
        this.followRedirects.setSelected(true);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.useKeepAlive.setName(USE_KEEPALIVE);
        this.useKeepAlive.setSelected(true);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.path);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.followRedirects);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.useKeepAlive);
        panel.setMinimumSize(panel.getPreferredSize());
        return panel;
    }

    protected JPanel getProtocolAndMethodPanel() {
        this.protocol = new JTextField(4);
        this.protocol.setName(PROTOCOL);
        JLabel protocolLabel = new JLabel(JMeterUtils.getResString((String)"protocol"));
        protocolLabel.setLabelFor(this.protocol);
        ButtonGroup methodButtonGroup = new ButtonGroup();
        this.get = new JRadioButton(JMeterUtils.getResString((String)"url_config_get"));
        methodButtonGroup.add(this.get);
        this.post = new JRadioButton(JMeterUtils.getResString((String)"url_config_post"));
        methodButtonGroup.add(this.post);
        this.post.setSelected(true);
        JLabel methodLabel = new JLabel(JMeterUtils.getResString((String)"method"));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(protocolLabel);
        panel.add(this.protocol);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(methodLabel);
        panel.add(this.get);
        panel.add(this.post);
        panel.setMinimumSize(panel.getPreferredSize());
        return panel;
    }

    protected JPanel getParameterPanel() {
        this.argsPanel = new HTTPArgumentsPanel();
        return this.argsPanel;
    }
}

