/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.util.Base64Encoder;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;

public class AuthManager
extends ConfigTestElement
implements ConfigElement,
Serializable {
    private static final String AUTH_LIST = "AuthManager.auth_list";
    private static final int columnCount = 3;
    private static final String[] columnNames = new String[]{JMeterUtils.getResString((String)"auth_base_url"), JMeterUtils.getResString((String)"username"), JMeterUtils.getResString((String)"password")};
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$gui$AuthPanel;

    public AuthManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(AUTH_LIST, new ArrayList()));
    }

    public void set(int index, String url, String user, String pass) {
        Authorization auth = new Authorization(url, user, pass);
        if (index >= 0) {
            this.getAuthObjects().set(index, (JMeterProperty)new TestElementProperty(auth.getName(), (TestElement)auth));
        } else {
            this.getAuthObjects().addItem((Object)auth);
        }
    }

    public void setName(String newName) {
        this.setProperty("TestElement.name", newName);
    }

    public CollectionProperty getAuthObjects() {
        return (CollectionProperty)this.getProperty(AUTH_LIST);
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return columnNames[column].getClass();
    }

    public Authorization getAuthObjectAt(int row) {
        return (Authorization)this.getAuthObjects().get(row).getObjectValue();
    }

    public boolean isEditable() {
        return true;
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"auth_manager_title");
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$protocol$http$gui$AuthPanel == null ? (class$org$apache$jmeter$protocol$http$gui$AuthPanel = AuthManager.class$("org.apache.jmeter.protocol.http.gui.AuthPanel")) : class$org$apache$jmeter$protocol$http$gui$AuthPanel;
    }

    public Collection getAddList() {
        return null;
    }

    public Authorization get(int i) {
        return (Authorization)this.getAuthObjects().get(i);
    }

    public String getAuthHeaderForURL(URL url) {
        if (this.isSupportedProtocol(url)) {
            return null;
        }
        StringBuffer header = new StringBuffer();
        PropertyIterator propertyIterator = this.getAuthObjects().iterator();
        while (propertyIterator.hasNext()) {
            Authorization auth = (Authorization)propertyIterator.next().getObjectValue();
            if (!url.toString().startsWith(auth.getURL())) continue;
            header.append("Basic " + Base64Encoder.encode(auth.getUser() + ":" + auth.getPass()));
            break;
        }
        if (header.length() != 0) {
            return header.toString();
        }
        return null;
    }

    public String getName() {
        return this.getPropertyAsString("TestElement.name");
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void addAuth(Authorization auth) {
        this.getAuthObjects().addItem((Object)auth);
    }

    public void addAuth() {
        this.getAuthObjects().addItem((Object)new Authorization());
    }

    public boolean expectsModification() {
        return false;
    }

    public void uncompile() {
    }

    public void save(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# JMeter generated Authorization file");
        int i = 0;
        while (i < this.getAuthObjects().size()) {
            Authorization auth = (Authorization)this.getAuthObjects().get(i);
            writer.println(auth.toString());
            ++i;
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(String authFile) throws IOException {
        String line;
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        BufferedReader reader = null;
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            void var4_4;
            try {
                if (var4_4.startsWith("#") || var4_4.trim().length() == 0) continue;
                StringTokenizer st = new StringTokenizer((String)var4_4, "\t");
                String url = st.nextToken();
                String user = st.nextToken();
                String pass = st.nextToken();
                Authorization auth = new Authorization(url, user, pass);
                this.getAuthObjects().addItem((Object)auth);
            }
            catch (Exception e) {
                throw new IOException("Error parsing auth line\n\t'" + (String)var4_4 + "'\n\t" + e);
            }
        }
        reader.close();
    }

    public void remove(int index) {
        this.getAuthObjects().remove(index);
    }

    public int size() {
        return this.getAuthObjects().size();
    }

    private boolean isSupportedProtocol(URL url) {
        return !url.getProtocol().toUpperCase().equals("HTTP") && !url.getProtocol().toUpperCase().equals("HTTPS");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

