/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Cookie
extends AbstractTestElement
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static String NAME = "Cookie.name";
    private static String VALUE = "Cookie.value";
    private static String DOMAIN = "Cookie.domain";
    private static String EXPIRES = "Cookie.expires";
    private static String SECURE = "Cookie.secure";
    private static String PATH = "Cookie.path";

    public Cookie() {
        this.setName("");
        this.setValue("");
        this.setDomain("");
        this.setPath("");
        this.setSecure(false);
        this.setExpires(0L);
    }

    public Cookie(String name, String value, String domain, String path, boolean secure, long expires) {
        this.setName(name);
        this.setValue(value);
        this.setDomain(domain);
        this.setPath(path);
        this.setSecure(secure);
        this.setExpires(expires);
    }

    public void addConfigElement(ConfigElement config) {
    }

    public boolean expectsModification() {
        return false;
    }

    public String getClassLabel() {
        return "Cookie";
    }

    public String getValue() {
        return this.getPropertyAsString(VALUE);
    }

    public synchronized void setValue(String value) {
        this.setProperty(VALUE, value);
    }

    public String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public synchronized void setDomain(String domain) {
        this.setProperty(DOMAIN, domain);
    }

    public long getExpires() {
        return this.getPropertyAsLong(EXPIRES);
    }

    public synchronized void setExpires(long expires) {
        this.setProperty((JMeterProperty)new LongProperty(EXPIRES, expires));
    }

    public boolean getSecure() {
        return this.getPropertyAsBoolean(SECURE);
    }

    public synchronized void setSecure(boolean secure) {
        this.setProperty((JMeterProperty)new BooleanProperty(SECURE, secure));
    }

    public String getPath() {
        return this.getPropertyAsString(PATH);
    }

    public synchronized void setPath(String path) {
        this.setProperty(PATH, path);
    }

    public String toString() {
        return this.getDomain() + "\tTRUE\t" + this.getPath() + "\t" + new Boolean(this.getSecure()).toString().toUpperCase() + "\t" + this.getExpires() + "\t" + this.getName() + "\t" + this.getValue();
    }
}

