/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CookieManager
extends ConfigTestElement
implements TestListener,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String CLEAR = "CookieManager.clearEachIteration";
    public static final String COOKIES = "CookieManager.cookies";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz");
    private static List addableList = new LinkedList();

    public CookieManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(COOKIES, new ArrayList()));
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR, false));
    }

    public CollectionProperty getCookies() {
        return (CollectionProperty)this.getProperty(COOKIES);
    }

    public int getCookieCount() {
        return this.getCookies().size();
    }

    public boolean getClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty((JMeterProperty)new BooleanProperty(CLEAR, clear));
    }

    public Cookie getCookie(int row) {
        return (Cookie)this.getCookies().get(row);
    }

    public void save(String authFile) throws IOException {
        File file = new File(authFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + authFile);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# JMeter generated Cookie file");
        PropertyIterator cookies = this.getCookies().iterator();
        while (cookies.hasNext()) {
            Cookie cook = (Cookie)cookies.next().getObjectValue();
            writer.println(cook.toString());
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(String cookieFile) throws IOException {
        String line;
        File file = new File(cookieFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + cookieFile);
        }
        BufferedReader reader = null;
        if (!file.canRead()) {
            throw new IOException("The file you specified cannot be read.");
        }
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            void var4_4;
            try {
                if (var4_4.startsWith("#") || var4_4.trim().length() == 0) continue;
                String[] st = this.split((String)var4_4, "\t", " ");
                int domain = 0;
                boolean foo = true;
                int path = 2;
                if (st[path].equals(" ")) {
                    st[path] = "/";
                }
                boolean secure = new Boolean(st[3]);
                long expires = new Long(st[4]);
                int name = 5;
                int value = 6;
                Cookie cookie = new Cookie(st[name], st[value], st[domain], st[path], secure, expires);
                this.getCookies().addItem((Object)cookie);
            }
            catch (Exception e) {
                throw new IOException("Error parsing cookie line\n\t'" + (String)var4_4 + "'\n\t" + e);
            }
        }
        reader.close();
    }

    public void recoverRunningVersion() {
    }

    public void setRunningVersion(boolean running) {
    }

    public void add(Cookie c) {
        this.getCookies().addItem((Object)c);
        if (JMeterContextService.getContext().isSamplingStarted()) {
            JMeterContextService.getContext().getVariables().put(c.getName(), c.getValue());
        }
    }

    public void add() {
        this.getCookies().addItem((Object)new Cookie());
    }

    public void clear() {
        this.setProperty((JMeterProperty)new CollectionProperty(COOKIES, new ArrayList()));
    }

    public void remove(int index) {
        this.getCookies().remove(index);
    }

    public int size() {
        return this.getCookies().size();
    }

    public Cookie get(int i) {
        return (Cookie)this.getCookies().get(i);
    }

    public String convertLongToDateFormatStr(long dateLong) {
        return dateFormat.format(new Date(dateLong));
    }

    public long convertDateFormatStrToLong(String dateStr) {
        long time = 0L;
        try {
            Date date = dateFormat.parse(dateStr);
            time = date.getTime();
        }
        catch (ParseException e) {
            time = 0L;
            log.error("DateFormat.ParseException: ", (Throwable)e);
        }
        return time;
    }

    public String getCookieHeaderForURL(URL url) {
        if (!url.getProtocol().toUpperCase().trim().equals("HTTP") && !url.getProtocol().toUpperCase().trim().equals("HTTPS")) {
            return null;
        }
        StringBuffer header = new StringBuffer();
        PropertyIterator propertyIterator = this.getCookies().iterator();
        while (propertyIterator.hasNext()) {
            Cookie cookie = (Cookie)propertyIterator.next().getObjectValue();
            if (!url.getHost().endsWith(cookie.getDomain()) || !url.getFile().startsWith(cookie.getPath()) || System.currentTimeMillis() / 1000L > cookie.getExpires()) continue;
            if (header.length() > 0) {
                header.append("; ");
            }
            header.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        if (header.length() != 0) {
            return header.toString();
        }
        return null;
    }

    public void addCookieFromHeader(String cookieHeader, URL url) {
        StringTokenizer st = new StringTokenizer(cookieHeader, ";");
        String nvp = st.nextToken();
        int index = nvp.indexOf("=");
        String name = nvp.substring(0, index);
        String value = nvp.substring(index + 1);
        String domain = url.getHost();
        String path = "/";
        Cookie newCookie = new Cookie(name, value, domain, path, false, System.currentTimeMillis() + 86400000L);
        while (st.hasMoreTokens()) {
            String key;
            nvp = st.nextToken();
            index = (nvp = nvp.trim()).indexOf("=");
            if (index == -1) {
                index = nvp.length();
            }
            if ((key = nvp.substring(0, index)).equalsIgnoreCase("expires")) {
                try {
                    String expires = nvp.substring(index + 1);
                    Date date = dateFormat.parse(expires);
                    if (date.getTime() <= System.currentTimeMillis()) continue;
                    newCookie.setExpires(date.getTime());
                }
                catch (ParseException pe) {}
                continue;
            }
            if (key.equalsIgnoreCase("domain")) {
                newCookie.setDomain(nvp.substring(index + 1));
                continue;
            }
            if (key.equalsIgnoreCase("path")) {
                newCookie.setPath(nvp.substring(index + 1));
                continue;
            }
            if (!key.equalsIgnoreCase("secure")) continue;
            newCookie.setSecure(true);
        }
        Vector<Integer> removeIndices = new Vector<Integer>();
        int i = this.getCookies().size() - 1;
        while (i >= 0) {
            Cookie cookie = (Cookie)this.getCookies().get(i).getObjectValue();
            if (cookie != null && cookie.getPath().equals(newCookie.getPath()) && cookie.getDomain().equals(newCookie.getDomain()) && cookie.getName().equals(newCookie.getName())) {
                removeIndices.addElement(new Integer(i));
            }
            --i;
        }
        Enumeration e = removeIndices.elements();
        while (e.hasMoreElements()) {
            index = (Integer)e.nextElement();
            this.remove(index);
        }
        if (newCookie.getExpires() >= System.currentTimeMillis()) {
            this.add(newCookie);
        }
    }

    public void removeCookieNamed(String name) {
        PropertyIterator iter = this.getCookies().iterator();
        while (iter.hasNext()) {
            Cookie cookie = (Cookie)iter.next().getObjectValue();
            if (!cookie.getName().equals(name)) continue;
            iter.remove();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String[] split(String splittee, String splitChar, String def) {
        if (splittee != null && splitChar != null) ** GOTO lbl4
        return new String[0];
lbl-1000:
        // 1 sources

        {
            splittee = splittee.substring(0, (int)(var6_4 + splitChar.length())) + def + splittee.substring((int)(var6_4 + 1 * splitChar.length()), splittee.length());
lbl4:
            // 2 sources

            ** while ((spot = splittee.indexOf((String)(splitChar + splitChar))) != -1)
        }
lbl5:
        // 1 sources

        returns = new Vector<String>();
        tokens = new StringTokenizer(splittee, splitChar);
        while (tokens.hasMoreTokens()) {
            temp = tokens.nextToken();
            returns.addElement(temp);
        }
        values = new String[returns.size()];
        returns.copyInto(values);
        return values;
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"cookie_manager_title");
    }

    public void testStarted() {
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
    }

    public void testEnded(String host) {
    }

    public void testIterationStart(LoopIterationEvent event) {
        if (this.getClearEachIteration()) {
            this.clear();
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testRemoveCookie() throws Exception {
            CookieManager man = new CookieManager();
            man.add(new Cookie("id", "me", "127.0.0.1", "/", false, 0L));
            man.removeCookieNamed("id");
            Assert.assertEquals((int)0, (int)man.getCookieCount());
        }

        public void testSendCookie() throws Exception {
            CookieManager man = new CookieManager();
            man.add(new Cookie("id", "value", "jakarta.apache.org", "/", false, 9999999999L));
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("jakarta.apache.org");
            sampler.setPath("/index.html");
            sampler.setMethod("GET");
            Assert.assertNotNull((Object)man.getCookieHeaderForURL(sampler.getUrl()));
        }

        public void testSendCookie2() throws Exception {
            CookieManager man = new CookieManager();
            man.add(new Cookie("id", "value", ".apache.org", "/", false, 9999999999L));
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("jakarta.apache.org");
            sampler.setPath("/index.html");
            sampler.setMethod("GET");
            Assert.assertNotNull((Object)man.getCookieHeaderForURL(sampler.getUrl()));
        }
    }
}

