/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.MultipartUrlConfigGui;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class HttpTestSampleGui
extends AbstractSamplerGui {
    private UrlConfigGui urlConfigGui;
    private JCheckBox getImages;

    public HttpTestSampleGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.urlConfigGui.configure(element);
        String testClass = element.getPropertyAsString("TestElement.test_class");
        this.getImages.setSelected(((HTTPSampler)element).isImageParser());
    }

    public TestElement createTestElement() {
        HTTPSampler sampler = new HTTPSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        TestElement el = this.urlConfigGui.createTestElement();
        sampler.clear();
        sampler.addTestElement(el);
        if (this.getImages.isSelected()) {
            ((HTTPSampler)sampler).setImageParser(true);
        } else {
            ((HTTPSampler)sampler).setImageParser(false);
        }
        this.configureTestElement(sampler);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"web_testing_title");
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlConfigGui = new MultipartUrlConfigGui();
        this.add(this.urlConfigGui, "Center");
        this.add(this.createOptionalTasksPanel(), "South");
    }

    private JPanel createOptionalTasksPanel() {
        VerticalPanel optionalTasksPanel = new VerticalPanel();
        optionalTasksPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        JPanel retrieveImagesPanel = new JPanel();
        this.getImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        retrieveImagesPanel.add(this.getImages);
        optionalTasksPanel.add((Component)retrieveImagesPanel);
        return optionalTasksPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clear() {
        super.clear();
        this.getImages.setSelected(false);
        this.urlConfigGui.clear();
    }

    public static class Test
    extends TestCase {
        HttpTestSampleGui gui;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.gui = new HttpTestSampleGui();
        }

        public void testCloneSampler() throws Exception {
            HTTPSampler sampler = (HTTPSampler)this.gui.createTestElement();
            sampler.addArgument("param", "value");
            HTTPSampler clonedSampler = (HTTPSampler)((Object)sampler.clone());
            clonedSampler.setRunningVersion(true);
            sampler.getArguments().getArgument(0).setValue("new value");
            Assert.assertEquals((String)"Sampler didn't clone correctly", (Object)"new value", (Object)sampler.getArguments().getArgument(0).getValue());
        }
    }
}

