/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.apache.jmeter.protocol.http.sampler.SoapSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class SoapSamplerGui
extends AbstractSamplerGui {
    private static final String label = JMeterUtils.getResString((String)"soap_sampler_title");
    private JLabeledTextField urlField;
    private JLabeledTextArea soapXml;

    public SoapSamplerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return label;
    }

    public TestElement createTestElement() {
        SoapSampler sampler = new SoapSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        this.configureTestElement(s);
        if (s instanceof SoapSampler) {
            SoapSampler sampler = (SoapSampler)s;
            sampler.setURLData(this.urlField.getText());
            sampler.setXmlData(this.soapXml.getText());
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlField = new JLabeledTextField(JMeterUtils.getResString((String)"url"), 10);
        this.soapXml = new JLabeledTextArea(JMeterUtils.getResString((String)"soap_data_title"), null);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.urlField, "North");
        mainPanel.add((Component)this.soapXml, "Center");
        this.add(mainPanel, "Center");
    }

    public void configure(TestElement el) {
        super.configure(el);
        SoapSampler sampler = (SoapSampler)el;
        this.urlField.setText(sampler.getURLData());
        this.soapXml.setText(sampler.getXmlData());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

