/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.protocol.http.sampler.WebServiceSampler;
import org.apache.jmeter.protocol.http.util.WSDLHelper;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class WebServiceSamplerGui
extends AbstractSamplerGui
implements ActionListener {
    private static final String label = JMeterUtils.getResString((String)"webservice_sampler_title");
    JLabeledTextField urlField = new JLabeledTextField(JMeterUtils.getResString((String)"url"));
    JLabeledTextField soapAction = new JLabeledTextField(JMeterUtils.getResString((String)"webservice_soap_action"));
    JLabeledTextArea soapXml = new JLabeledTextArea(JMeterUtils.getResString((String)"soap_data_title"), null);
    JLabeledTextField wsdlField = new JLabeledTextField(JMeterUtils.getResString((String)"wsdl_url"));
    JButton wsdlButton = new JButton(JMeterUtils.getResString((String)"load_wsdl"));
    JButton selectButton = new JButton(JMeterUtils.getResString((String)"configure_wsdl"));
    JLabeledChoice wsdlMethods = null;
    WSDLHelper HELPER = null;
    FilePanel soapXmlFile = new FilePanel(JMeterUtils.getResString((String)"get_xml_from_file"), ".xml");
    JLabeledTextField randomXmlFile = new JLabeledTextField(JMeterUtils.getResString((String)"get_xml_from_random"));
    JLabel wsdlMessage = new JLabel(JMeterUtils.getResString((String)"get_xml_message"));
    JLabel wsdlMessage2 = new JLabel(JMeterUtils.getResString((String)"get_xml_message2"));
    JLabel wsdlMessage3 = new JLabel(JMeterUtils.getResString((String)"get_xml_message3"));
    JLabel wsdlMessage4 = new JLabel(JMeterUtils.getResString((String)"get_xml_message4"));
    JLabel wsdlMessage5 = new JLabel(JMeterUtils.getResString((String)"get_xml_message5"));
    Font plainText = new Font("plain", 0, 10);
    JCheckBox memCache = new JCheckBox(JMeterUtils.getResString((String)"memory_cache"), true);
    JCheckBox readResponse = new JCheckBox(JMeterUtils.getResString((String)"read_soap_response"));
    JLabel readMessage = new JLabel(JMeterUtils.getResString((String)"read_response_note"));
    JLabel readMessage2 = new JLabel(JMeterUtils.getResString((String)"read_response_note2"));
    JLabel readMessage3 = new JLabel(JMeterUtils.getResString((String)"read_response_note3"));

    public WebServiceSamplerGui() {
        this.init();
    }

    public String getStaticLabel() {
        return label;
    }

    public TestElement createTestElement() {
        WebServiceSampler sampler = new WebServiceSampler();
        this.configureTestElement((TestElement)sampler);
        try {
            URL url = new URL(this.urlField.getText());
            sampler.setDomain(url.getHost());
            if (url.getPort() != -1) {
                sampler.setPort(url.getPort());
            } else {
                sampler.setPort(80);
            }
            sampler.setProtocol(url.getProtocol());
            sampler.setMethod("POST");
            sampler.setPath(url.getPath());
            sampler.setSoapAction(this.soapAction.getText());
            sampler.setXmlData(this.soapXml.getText());
            sampler.setXmlFile(this.soapXmlFile.getFilename());
            sampler.setXmlPathLoc(this.randomXmlFile.getText());
            sampler.setMemoryCache(this.memCache.isSelected());
            sampler.setReadResponse(this.readResponse.isSelected());
        }
        catch (MalformedURLException e) {}
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        WebServiceSampler sampler = (WebServiceSampler)s;
        this.configureTestElement((TestElement)sampler);
        try {
            URL url = new URL(this.urlField.getText());
            sampler.setDomain(url.getHost());
            if (url.getPort() != -1) {
                sampler.setPort(url.getPort());
            } else {
                sampler.setPort(80);
            }
            sampler.setProtocol(url.getProtocol());
            sampler.setMethod("POST");
            sampler.setPath(url.getPath());
            sampler.setSoapAction(this.soapAction.getText());
            sampler.setXmlData(this.soapXml.getText());
            sampler.setXmlFile(this.soapXmlFile.getFilename());
            sampler.setXmlPathLoc(this.randomXmlFile.getText());
            sampler.setMemoryCache(this.memCache.isSelected());
            sampler.setReadResponse(this.readResponse.isSelected());
        }
        catch (MalformedURLException e) {}
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        this.wsdlMessage.setFont(this.plainText);
        this.wsdlMessage2.setFont(this.plainText);
        this.wsdlMessage3.setFont(this.plainText);
        this.wsdlMessage4.setFont(this.plainText);
        this.wsdlMessage5.setFont(this.plainText);
        this.readMessage.setFont(this.plainText);
        this.readMessage2.setFont(this.plainText);
        this.readMessage3.setFont(this.plainText);
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(label);
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        mainPanel.add((Component)this.getNamePanel());
        JPanel wsdlEntry = new JPanel();
        mainPanel.add(wsdlEntry);
        wsdlEntry.add((Component)this.wsdlField);
        wsdlEntry.add(this.wsdlButton);
        this.wsdlButton.addActionListener(this);
        JPanel listPanel = new JPanel();
        JLabel selectLabel = new JLabel("Web Methods");
        this.wsdlMethods = new JLabeledChoice();
        mainPanel.add(listPanel);
        listPanel.add(selectLabel);
        listPanel.add((Component)this.wsdlMethods);
        listPanel.add(this.selectButton);
        this.selectButton.addActionListener(this);
        mainPanel.add((Component)this.urlField);
        mainPanel.add((Component)this.soapAction);
        mainPanel.add((Component)this.soapXml);
        mainPanel.add((Component)this.soapXmlFile);
        mainPanel.add(this.wsdlMessage);
        mainPanel.add(this.wsdlMessage2);
        mainPanel.add(this.wsdlMessage3);
        mainPanel.add(this.wsdlMessage4);
        mainPanel.add(this.wsdlMessage5);
        mainPanel.add((Component)this.randomXmlFile);
        mainPanel.add(this.memCache);
        mainPanel.add(this.readResponse);
        mainPanel.add(this.readMessage);
        mainPanel.add(this.readMessage2);
        mainPanel.add(this.readMessage3);
        this.add(mainPanel);
    }

    public void configure(TestElement el) {
        super.configure(el);
        WebServiceSampler sampler = (WebServiceSampler)el;
        try {
            if (sampler.getUrl() != null && sampler.getUrl().getHost() != null) {
                this.urlField.setText(sampler.getUrl().toString());
            }
            this.soapAction.setText(sampler.getSoapAction());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int port = sampler.getPort();
        String strUrl = sampler.getProtocol() + "://" + sampler.getDomain();
        if (port != -1 && port != 80) {
            strUrl = strUrl + ":" + sampler.getPort();
        }
        strUrl = strUrl + sampler.getPath() + "?" + sampler.getQueryString();
        this.urlField.setText(strUrl);
        this.soapXml.setText(sampler.getXmlData());
        this.soapXmlFile.setFilename(sampler.getXmlFile());
        this.randomXmlFile.setText(sampler.getXmlPathLoc());
        this.memCache.setSelected(sampler.getMemoryCache());
        this.readResponse.setSelected(sampler.getReadResponse());
    }

    public void configureFromWSDL() {
        if (this.HELPER.getBinding() != null) {
            this.urlField.setText(this.HELPER.getBinding());
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append("http://" + this.HELPER.getURL().getHost());
            if (this.HELPER.getURL().getPort() != -1) {
                buf.append(":" + this.HELPER.getURL().getPort());
            } else {
                buf.append(":80");
            }
            buf.append(this.HELPER.getURL().getPath());
            this.urlField.setText(buf.toString());
        }
        this.soapAction.setText(this.HELPER.getSoapAction(this.wsdlMethods.getText()));
    }

    public String[] browseWSDL(String url) {
        try {
            this.HELPER = new WSDLHelper(url);
            this.HELPER.parse();
            return this.HELPER.getWebMethods();
        }
        catch (Exception exception) {
            JOptionPane.showConfirmDialog((Component)((Object)this), JMeterUtils.getResString((String)"wsdl_helper_error"), "Warning", 2, 0);
            return null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.selectButton) {
            this.configureFromWSDL();
        } else if (this.urlField.getText() != null) {
            String[] wsdlData = this.browseWSDL(this.wsdlField.getText());
            if (wsdlData != null) {
                this.wsdlMethods.setValues(wsdlData);
                this.wsdlMethods.repaint();
            }
        } else {
            JOptionPane.showConfirmDialog((Component)((Object)this), JMeterUtils.getResString((String)"wsdl_url_error"), "Warning", 2, 0);
        }
    }
}

