/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class AuthPanel
extends AbstractConfigGui
implements ActionListener {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private InnerTableModel tableModel = new InnerTableModel();
    private JTable authTable;
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;

    public AuthPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        AuthManager authMan = this.tableModel.manager;
        this.configureTestElement((TestElement)authMan);
        return (TestElement)authMan.clone();
    }

    public void modifyTestElement(TestElement el) {
        el.clear();
        el.addTestElement((TestElement)this.tableModel.manager.clone());
        this.configureTestElement(el);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.manager.clear();
        this.tableModel.manager.addTestElement((TestElement)((AuthManager)el.clone()));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"auth_manager_title");
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createAuthTablePanel(), "Center");
    }

    public void actionPerformed(ActionEvent e) {
        block16: {
            String action;
            block19: {
                block18: {
                    block17: {
                        int rowSelected;
                        action = e.getActionCommand();
                        if (!action.equals(DELETE_COMMAND)) break block17;
                        if (this.tableModel.getRowCount() <= 0) break block16;
                        if (this.authTable.isEditing()) {
                            TableCellEditor cellEditor = this.authTable.getCellEditor(this.authTable.getEditingRow(), this.authTable.getEditingColumn());
                            cellEditor.cancelCellEditing();
                        }
                        if ((rowSelected = this.authTable.getSelectedRow()) != -1) {
                            this.tableModel.removeRow(rowSelected);
                            this.tableModel.fireTableDataChanged();
                            if (this.tableModel.getRowCount() == 0) {
                                this.deleteButton.setEnabled(false);
                                this.saveButton.setEnabled(false);
                            } else {
                                int rowToSelect = rowSelected;
                                if (rowSelected >= this.tableModel.getRowCount()) {
                                    rowToSelect = rowSelected - 1;
                                }
                                this.authTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                            }
                        }
                        break block16;
                    }
                    if (!action.equals(ADD_COMMAND)) break block18;
                    if (this.authTable.isEditing()) {
                        TableCellEditor cellEditor = this.authTable.getCellEditor(this.authTable.getEditingRow(), this.authTable.getEditingColumn());
                        cellEditor.stopCellEditing();
                    }
                    this.tableModel.addNewRow();
                    this.tableModel.fireTableDataChanged();
                    if (!this.deleteButton.isEnabled()) {
                        this.deleteButton.setEnabled(true);
                    }
                    if (!this.saveButton.isEnabled()) {
                        this.saveButton.setEnabled(true);
                    }
                    int rowToSelect = this.tableModel.getRowCount() - 1;
                    this.authTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                    break block16;
                }
                if (!action.equals(LOAD_COMMAND)) break block19;
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block16;
                    this.tableModel.manager.addFile(tmp.getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                    break block16;
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
                break block16;
            }
            if (!action.equals(SAVE_COMMAND)) break block16;
            try {
                File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                if (tmp != null) {
                    this.tableModel.manager.save(tmp.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
            catch (NullPointerException err) {}
        }
    }

    public JPanel createAuthTablePanel() {
        this.authTable = new JTable(this.tableModel);
        this.authTable.setSelectionMode(0);
        this.authTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        TableColumn passwordColumn = this.authTable.getColumnModel().getColumn(2);
        passwordColumn.setCellEditor(new DefaultCellEditor(new JPasswordField()));
        passwordColumn.setCellRenderer(new PasswordCellRenderer());
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"auths_stored")));
        panel.add(new JScrollPane(this.authTable));
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    private class PasswordCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        private Border myBorder = new EmptyBorder(1, 2, 1, 2);

        public PasswordCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.myBorder);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            this.setFont(table.getFont());
            return this;
        }
    }

    private class InnerTableModel
    extends AbstractTableModel {
        AuthManager manager;

        public InnerTableModel(AuthManager man) {
            this.manager = man;
        }

        public InnerTableModel() {
            this.manager = new AuthManager();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.addAuth();
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public int getRowCount() {
            return this.manager.getAuthObjects().size();
        }

        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        public Object getValueAt(int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            if (column == 0) {
                return auth.getURL();
            }
            if (column == 1) {
                return auth.getUser();
            }
            if (column == 2) {
                return auth.getPass();
            }
            return null;
        }

        public void setValueAt(Object value, int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            log.debug("Setting auth value: " + value);
            if (column == 0) {
                auth.setURL((String)value);
            } else if (column == 1) {
                auth.setUser((String)value);
            } else if (column == 2) {
                auth.setPass((String)value);
            }
        }
    }
}

