/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CookiePanel
extends AbstractConfigGui
implements ActionListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private JTable cookieTable;
    private PowerTableModel tableModel = new PowerTableModel(columnNames, columnClasses);
    private JCheckBox clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"clear_cookies_per_iter"), false);
    private static final String clearEachIterationLabel = "clear_cookies_per_iter";
    private static final String[] columnNames = new String[]{JMeterUtils.getResString((String)"name"), JMeterUtils.getResString((String)"value"), JMeterUtils.getResString((String)"domain"), JMeterUtils.getResString((String)"path"), JMeterUtils.getResString((String)"secure"), JMeterUtils.getResString((String)"expiration")};
    private static final Class[] columnClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CookiePanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CookiePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Long == null ? (class$java$lang$Long = CookiePanel.class$("java.lang.Long")) : class$java$lang$Long};
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;

    public CookiePanel() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"cookie_manager_title");
    }

    public void actionPerformed(ActionEvent e) {
        block16: {
            String action;
            block19: {
                block18: {
                    block17: {
                        int rowSelected;
                        action = e.getActionCommand();
                        if (!action.equals(DELETE_COMMAND)) break block17;
                        if (this.tableModel.getRowCount() <= 0) break block16;
                        if (this.cookieTable.isEditing()) {
                            TableCellEditor cellEditor = this.cookieTable.getCellEditor(this.cookieTable.getEditingRow(), this.cookieTable.getEditingColumn());
                            cellEditor.cancelCellEditing();
                        }
                        if ((rowSelected = this.cookieTable.getSelectedRow()) != -1) {
                            this.tableModel.removeRow(rowSelected);
                            this.tableModel.fireTableDataChanged();
                            if (this.tableModel.getRowCount() == 0) {
                                this.deleteButton.setEnabled(false);
                                this.saveButton.setEnabled(false);
                            } else {
                                int rowToSelect = rowSelected;
                                if (rowSelected >= this.tableModel.getRowCount()) {
                                    rowToSelect = rowSelected - 1;
                                }
                                this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                            }
                        }
                        break block16;
                    }
                    if (!action.equals(ADD_COMMAND)) break block18;
                    if (this.cookieTable.isEditing()) {
                        TableCellEditor cellEditor = this.cookieTable.getCellEditor(this.cookieTable.getEditingRow(), this.cookieTable.getEditingColumn());
                        cellEditor.stopCellEditing();
                    }
                    this.tableModel.addNewRow();
                    this.tableModel.fireTableDataChanged();
                    if (!this.deleteButton.isEnabled()) {
                        this.deleteButton.setEnabled(true);
                    }
                    if (!this.saveButton.isEnabled()) {
                        this.saveButton.setEnabled(true);
                    }
                    int rowToSelect = this.tableModel.getRowCount() - 1;
                    this.cookieTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                    break block16;
                }
                if (!action.equals(LOAD_COMMAND)) break block19;
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block16;
                    CookieManager manager = new CookieManager();
                    manager.addFile(tmp.getAbsolutePath());
                    Cookie cookie = manager.get(0);
                    this.addCookieToTable(cookie);
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                    break block16;
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
                break block16;
            }
            if (!action.equals(SAVE_COMMAND)) break block16;
            try {
                File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                if (tmp != null) {
                    ((CookieManager)this.createTestElement()).save(tmp.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
            catch (NullPointerException err) {}
        }
    }

    private void addCookieToTable(Cookie cookie) {
        this.tableModel.addRow(new Object[]{cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Boolean(cookie.getSecure()), new Long(cookie.getExpires())});
    }

    public void modifyTestElement(TestElement cm) {
        cm.clear();
        this.configureTestElement(cm);
        if (cm instanceof CookieManager) {
            CookieManager cookieManager = (CookieManager)cm;
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                Cookie cookie = this.createCookie(this.tableModel.getRowData(i));
                cookieManager.add(cookie);
                ++i;
            }
            cookieManager.setClearEachIteration(this.clearEachIteration.isSelected());
        }
    }

    private Cookie createCookie(Object[] rowData) {
        Cookie cookie = new Cookie((String)rowData[0], (String)rowData[1], (String)rowData[2], (String)rowData[3], (Boolean)rowData[4], (Long)rowData[5]);
        return cookie;
    }

    private void populateTable(CookieManager manager) {
        this.tableModel.clearData();
        PropertyIterator iter = manager.getCookies().iterator();
        while (iter.hasNext()) {
            this.addCookieToTable((Cookie)iter.next().getObjectValue());
        }
    }

    public TestElement createTestElement() {
        CookieManager cookieManager = new CookieManager();
        this.modifyTestElement((TestElement)cookieManager);
        return cookieManager;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.populateTable((CookieManager)el);
        this.clearEachIteration.setSelected(((CookieManager)el).getClearEachIteration());
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        northPanel.add(this.makeTitlePanel());
        northPanel.add(this.clearEachIteration);
        this.add(northPanel, "North");
        this.add(this.createCookieTablePanel(), "Center");
    }

    public JPanel createCookieTablePanel() {
        this.cookieTable = new JTable((TableModel)this.tableModel);
        this.cookieTable.setSelectionMode(0);
        this.cookieTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel buttonPanel = this.createButtonPanel();
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"cookies_stored")));
        panel.add((Component)new JScrollPane(this.cookieTable), "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

