/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class HeaderPanel
extends AbstractConfigGui
implements ActionListener,
FocusListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private InnerTableModel tableModel = new InnerTableModel();
    private JTable headerTable;
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;

    public HeaderPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        HeaderManager headerManager = this.tableModel.manager;
        this.configureTestElement((TestElement)headerManager);
        return (TestElement)headerManager.clone();
    }

    public void modifyTestElement(TestElement el) {
        el.clear();
        el.addTestElement((TestElement)this.tableModel.manager);
        this.configureTestElement(el);
    }

    public void configure(TestElement el) {
        this.tableModel.manager.clear();
        super.configure(el);
        this.tableModel.manager.addTestElement((TestElement)((HeaderManager)el));
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"header_manager_title");
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createHeaderTablePanel(), "Center");
    }

    public void actionPerformed(ActionEvent e) {
        block16: {
            String action;
            block19: {
                block18: {
                    block17: {
                        int rowSelected;
                        action = e.getActionCommand();
                        if (!action.equals(DELETE_COMMAND)) break block17;
                        if (this.tableModel.getRowCount() <= 0) break block16;
                        if (this.headerTable.isEditing()) {
                            TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                            cellEditor.cancelCellEditing();
                        }
                        if ((rowSelected = this.headerTable.getSelectedRow()) != -1) {
                            this.tableModel.removeRow(rowSelected);
                            this.tableModel.fireTableDataChanged();
                            if (this.tableModel.getRowCount() == 0) {
                                this.deleteButton.setEnabled(false);
                                this.saveButton.setEnabled(false);
                            } else {
                                int rowToSelect = rowSelected;
                                if (rowSelected >= this.tableModel.getRowCount()) {
                                    rowToSelect = rowSelected - 1;
                                }
                                this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                            }
                        }
                        break block16;
                    }
                    if (!action.equals(ADD_COMMAND)) break block18;
                    if (this.headerTable.isEditing()) {
                        TableCellEditor cellEditor = this.headerTable.getCellEditor(this.headerTable.getEditingRow(), this.headerTable.getEditingColumn());
                        cellEditor.stopCellEditing();
                    }
                    this.tableModel.addNewRow();
                    this.tableModel.fireTableDataChanged();
                    if (!this.deleteButton.isEnabled()) {
                        this.deleteButton.setEnabled(true);
                    }
                    if (!this.saveButton.isEnabled()) {
                        this.saveButton.setEnabled(true);
                    }
                    int rowToSelect = this.tableModel.getRowCount() - 1;
                    this.headerTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                    break block16;
                }
                if (!action.equals(LOAD_COMMAND)) break block19;
                try {
                    File tmp = FileDialoger.promptToOpenFile().getSelectedFile();
                    if (tmp == null) break block16;
                    this.tableModel.manager.addFile(tmp.getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    if (this.tableModel.getRowCount() > 0) {
                        this.deleteButton.setEnabled(true);
                        this.saveButton.setEnabled(true);
                    }
                    break block16;
                }
                catch (IOException ex) {
                    log.error("", (Throwable)ex);
                }
                catch (NullPointerException err) {}
                break block16;
            }
            if (!action.equals(SAVE_COMMAND)) break block16;
            try {
                File tmp = FileDialoger.promptToSaveFile(null).getSelectedFile();
                if (tmp != null) {
                    this.tableModel.manager.save(tmp.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
            catch (NullPointerException err) {}
        }
    }

    public JPanel createHeaderTablePanel() {
        this.headerTable = new JTable(this.tableModel);
        this.headerTable.addFocusListener(this);
        this.headerTable.setSelectionMode(0);
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"headers_stored")));
        panel.add((Component)new JScrollPane(this.headerTable), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            this.headerTable.getCellEditor().stopCellEditing();
        }
        catch (RuntimeException err) {}
    }

    private class InnerTableModel
    extends AbstractTableModel {
        HeaderManager manager;

        public InnerTableModel(HeaderManager man) {
            this.manager = man;
        }

        public InnerTableModel() {
            this.manager = new HeaderManager();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.add();
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public int getRowCount() {
            return this.manager.getHeaders().size();
        }

        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        public Object getValueAt(int row, int column) {
            Header head = this.manager.getHeader(row);
            if (column == 0) {
                return head.getName();
            }
            if (column == 1) {
                return head.getValue();
            }
            return null;
        }

        public void setValueAt(Object value, int row, int column) {
            Header header = this.manager.getHeader(row);
            if (column == 0) {
                header.setName((String)value);
            } else if (column == 1) {
                header.setValue((String)value);
            }
        }
    }

    class HeaderUpdater
    implements ActionListener {
        JTextField nameField = new JTextField(20);
        JTextField valueField = new JTextField(20);
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        int index;
        JDialog updateDialog;

        public JPanel getPanel() {
            JPanel main = new JPanel();
            GridBagLayout g = new GridBagLayout();
            main.setLayout(g);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            JLabel nameLabel = new JLabel(JMeterUtils.getResString((String)"name") + ":");
            c.gridx = 1;
            c.gridy = 1;
            g.setConstraints(nameLabel, c);
            main.add(nameLabel);
            JLabel valueLabel = new JLabel(JMeterUtils.getResString((String)"value") + ":");
            c.gridx = 1;
            c.gridy = 2;
            g.setConstraints(valueLabel, c);
            main.add(valueLabel);
            c.gridx = 2;
            c.gridy = 1;
            g.setConstraints(this.nameField, c);
            main.add(this.nameField);
            c.gridx = 2;
            c.gridy = 2;
            g.setConstraints(this.valueField, c);
            main.add(this.valueField);
            JPanel buttons = new JPanel();
            this.ok.setPreferredSize(this.cancel.getPreferredSize());
            buttons.add(this.ok);
            buttons.add(this.cancel);
            c.gridwidth = 2;
            c.gridx = 1;
            c.gridy = 7;
            g.setConstraints(buttons, c);
            main.add(buttons);
            return main;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            boolean valid = true;
            this.index = -1;
            if (command.equals("Edit")) {
                this.index = HeaderPanel.this.headerTable.getSelectedRow();
                if (this.index < 0) {
                    valid = false;
                } else {
                    Header c = ((HeaderPanel)HeaderPanel.this).tableModel.manager.get(this.index);
                    this.nameField = new JTextField(c.getName(), 20);
                    this.valueField = new JTextField(c.getValue(), 20);
                    this.ok = new JButton("Ok");
                    this.cancel = new JButton("Cancel");
                }
            } else if (command.equals(HeaderPanel.ADD_COMMAND)) {
                this.nameField = new JTextField(20);
                this.valueField = new JTextField(20);
                this.ok = new JButton("Ok");
                this.cancel = new JButton("Cancel");
            }
            if (valid) {
                if (this.updateDialog != null) {
                    this.updateDialog.dispose();
                }
                this.updateDialog = new JDialog();
                this.updateDialog.setSize(350, 300);
                this.ok.addActionListener(new ActionListener(this){
                    private final /* synthetic */ HeaderUpdater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        int i = this.this$1.index;
                        Header c = new Header();
                        if (i >= 0) {
                            c = HeaderPanel.access$100((HeaderPanel)HeaderUpdater.access$200((HeaderUpdater)this.this$1)).manager.get(this.this$1.index);
                        }
                        c.setName(this.this$1.nameField.getText());
                        c.setValue(this.this$1.valueField.getText());
                        if (i < 0) {
                            HeaderPanel.access$100((HeaderPanel)HeaderUpdater.access$200((HeaderUpdater)this.this$1)).manager.add(c);
                        }
                        HeaderPanel.access$100(HeaderUpdater.access$200(this.this$1)).fireTableDataChanged();
                        this.this$1.updateDialog.dispose();
                    }
                });
                this.cancel.addActionListener(new ActionListener(this){
                    private final /* synthetic */ HeaderUpdater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        this.this$1.updateDialog.dispose();
                    }
                });
                this.updateDialog.getContentPane().add(this.getPanel());
                this.updateDialog.show();
            }
        }

        static /* synthetic */ HeaderPanel access$200(HeaderUpdater x0) {
            return x0.HeaderPanel.this;
        }
    }
}

