/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.parser.HtmlParser;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.io.TextFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AnchorModifier
extends AbstractTestElement
implements PreProcessor,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static Random rand = new Random();

    public void process() {
        Document html;
        SampleResult result = JMeterContextService.getContext().getPreviousResult();
        Sampler sam = JMeterContextService.getContext().getCurrentSampler();
        HTTPSampler sampler = null;
        if (result == null || !(sam instanceof HTTPSampler)) {
            return;
        }
        sampler = (HTTPSampler)sam;
        ArrayList potentialLinks = new ArrayList();
        String responseText = "";
        try {
            responseText = new String(result.getResponseData(), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            int index = responseText.indexOf("<");
            if (index == -1) {
                index = 0;
            }
            html = (Document)HtmlParser.getDOM(responseText.substring(index));
        }
        catch (SAXException e) {
            return;
        }
        this.addAnchorUrls(html, result, sampler, potentialLinks);
        this.addFormUrls(html, result, sampler, potentialLinks);
        if (potentialLinks.size() > 0) {
            HTTPSampler url = (HTTPSampler)((Object)potentialLinks.get(rand.nextInt(potentialLinks.size())));
            sampler.setDomain(url.getDomain());
            sampler.setPath(url.getPath());
            if (url.getMethod().equals("POST")) {
                PropertyIterator iter = sampler.getArguments().iterator();
                while (iter.hasNext()) {
                    Argument arg = (Argument)iter.next().getObjectValue();
                    this.modifyArgument(arg, url.getArguments());
                }
            } else {
                sampler.setArguments(url.getArguments());
            }
            sampler.setProtocol(url.getProtocol());
            return;
        }
    }

    private void modifyArgument(Argument arg, Arguments args) {
        Argument replacementArg;
        log.debug("Modifying argument: " + arg);
        ArrayList<Argument> possibleReplacements = new ArrayList<Argument>();
        PropertyIterator iter = args.iterator();
        while (iter.hasNext()) {
            replacementArg = (Argument)iter.next().getObjectValue();
            try {
                if (!HtmlParser.isArgumentMatched(replacementArg, arg)) continue;
                possibleReplacements.add(replacementArg);
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
        if (possibleReplacements.size() > 0) {
            replacementArg = (Argument)possibleReplacements.get(rand.nextInt(possibleReplacements.size()));
            arg.setName(replacementArg.getName());
            arg.setValue(replacementArg.getValue());
            log.debug("Just set argument to values: " + arg.getName() + " = " + arg.getValue());
            args.removeArgument(replacementArg);
        }
    }

    public void addConfigElement(ConfigElement config) {
    }

    private void addFormUrls(Document html, SampleResult result, HTTPSampler config, List potentialLinks) {
        NodeList rootList = html.getChildNodes();
        LinkedList urls = new LinkedList();
        int x = 0;
        while (x < rootList.getLength()) {
            urls.addAll(HtmlParser.createURLFromForm(rootList.item(x), (HTTPSampler)JMeterContextService.getContext().getPreviousSampler()));
            ++x;
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            HTTPSampler newUrl = (HTTPSampler)((Object)iter.next());
            try {
                newUrl.setMethod("POST");
                if (!HtmlParser.isAnchorMatched(newUrl, config)) continue;
                potentialLinks.add(newUrl);
            }
            catch (MalformedPatternException e) {
                log.error("Bad pattern", (Throwable)e);
            }
        }
    }

    private void addAnchorUrls(Document html, SampleResult result, HTTPSampler config, List potentialLinks) {
        NodeList nodeList = html.getElementsByTagName("a");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("href");
            if (namedItem != null) {
                String hrefStr = namedItem.getNodeValue();
                try {
                    HTTPSampler newUrl = HtmlParser.createUrlFromAnchor(hrefStr, (HTTPSampler)JMeterContextService.getContext().getPreviousSampler());
                    newUrl.setMethod("GET");
                    log.debug("possible match: " + (Object)((Object)newUrl));
                    if (HtmlParser.isAnchorMatched(newUrl, config)) {
                        log.debug("Is a match! " + (Object)((Object)newUrl));
                        potentialLinks.add(newUrl);
                    }
                }
                catch (MalformedURLException e) {
                }
                catch (MalformedPatternException e) {
                    log.error("Bad pattern", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testModifySampler() throws Exception {
            HTTPSampler config = (HTTPSampler)((Object)SaveService.loadSubTree((InputStream)new FileInputStream(System.getProperty("user.dir") + "/testfiles/load_bug_list.jmx")).getArray()[0]);
            config.setRunningVersion(true);
            SampleResult result = new SampleResult();
            HTTPSampler context = (HTTPSampler)((Object)SaveService.loadSubTree((InputStream)new FileInputStream(System.getProperty("user.dir") + "/testfiles/Load_JMeter_Page.jmx")).getArray()[0]);
            JMeterContextService.getContext().setCurrentSampler((Sampler)context);
            JMeterContextService.getContext().setCurrentSampler((Sampler)config);
            result.setResponseData(new TextFile(System.getProperty("user.dir") + "/testfiles/jmeter_home_page.html").getText().getBytes());
            result.setSampleLabel(context.toString());
            result.setSamplerData(context.toString());
            JMeterContextService.getContext().setPreviousResult(result);
            AnchorModifier modifier = new AnchorModifier();
            modifier.process();
            Assert.assertEquals((Object)"http://nagoya.apache.org/bugzilla/buglist.cgi?bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&email1=&emailtype1=substring&emailassigned_to1=1&email2=&emailtype2=substring&emailreporter2=1&bugidtype=include&bug_id=&changedin=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&product=JMeter&short_desc=&short_desc_type=substring&long_desc=&long_desc_type=substring&bug_file_loc=&bug_file_loc_type=substring&keywords=&keywords_type=anywords&field0-0-0=noop&type0-0-0=noop&value0-0-0=&cmdtype=doit&order=Reuse+same+sort+as+last+time", (Object)config.toString());
            config.recoverRunningVersion();
            Assert.assertEquals((Object)"http://nagoya.apache.org/bugzilla/buglist.cgi?bug_status=.*&bug_status=.*&bug_status=.*&email1=&emailtype1=substring&emailassigned_to1=1&email2=&emailtype2=substring&emailreporter2=1&bugidtype=include&bug_id=&changedin=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&product=JMeter&short_desc=&short_desc_type=substring&long_desc=&long_desc_type=substring&bug_file_loc=&bug_file_loc_type=substring&keywords=&keywords_type=anywords&field0-0-0=noop&type0-0-0=noop&value0-0-0=&cmdtype=doit&order=Reuse+same+sort+as+last+time", (Object)config.toString());
        }
    }
}

