/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class URLRewritingModifier
extends AbstractTestElement
implements Serializable,
PreProcessor {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private Pattern case1;
    private Pattern case2;
    private Pattern case3;
    private Pattern case4;
    transient Perl5Compiler compiler = new Perl5Compiler();
    private static final String ARGUMENT_NAME = "argument_name";
    private static final String PATH_EXTENSION = "path_extension";
    private static final String PATH_EXTENSION_NO_EQUALS = "path_extension_no_equals";

    public void process() {
        Sampler sampler = JMeterContextService.getContext().getCurrentSampler();
        SampleResult responseText = JMeterContextService.getContext().getPreviousResult();
        if (responseText == null) {
            return;
        }
        this.initRegex(this.getArgumentName());
        String text = new String(responseText.getResponseData());
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        String value = "";
        if (matcher.contains(text, this.case1)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        } else if (matcher.contains(text, this.case2)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        } else if (matcher.contains(text, this.case3)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        } else if (matcher.contains(text, this.case4)) {
            MatchResult result = matcher.getMatch();
            value = result.group(1);
        }
        this.modify((HTTPSampler)sampler, value);
    }

    private void modify(HTTPSampler sampler, String value) {
        if (this.isPathExtension()) {
            if (this.isPathExtensionNoEquals()) {
                sampler.setPath(sampler.getPath() + ";" + this.getArgumentName() + value);
            } else {
                sampler.setPath(sampler.getPath() + ";" + this.getArgumentName() + "=" + value);
            }
        } else {
            sampler.getArguments().removeArgument(this.getArgumentName());
            sampler.getArguments().addArgument((Argument)new HTTPArgument(this.getArgumentName(), value, true));
        }
    }

    public void setArgumentName(String argName) {
        this.setProperty(ARGUMENT_NAME, argName);
    }

    private void initRegex(String argName) {
        this.case1 = JMeterUtils.getPatternCache().getPattern(argName + "=([^\"'>& \n\r;]*)[& \\n\\r\"'>;]?$?", 8);
        this.case2 = JMeterUtils.getPatternCache().getPattern("[Nn][Aa][Mm][Ee]=\"" + argName + "\"[^>]+[vV][Aa][Ll][Uu][Ee]=\"([^\"]*)\"", 8);
        this.case3 = JMeterUtils.getPatternCache().getPattern("[vV][Aa][Ll][Uu][Ee]=\"([^\"]*)\"[^>]+[Nn][Aa][Mm][Ee]=\"" + argName + "\"", 8);
        this.case4 = JMeterUtils.getPatternCache().getPattern(argName + "([^\"'>& \n\r]*)[& \\n\\r\"'>]?$?", 8);
    }

    public String getArgumentName() {
        return this.getPropertyAsString(ARGUMENT_NAME);
    }

    public void setPathExtension(boolean pathExt) {
        this.setProperty((JMeterProperty)new BooleanProperty(PATH_EXTENSION, pathExt));
    }

    public void setPathExtensionNoEquals(boolean pathExtNoEquals) {
        this.setProperty((JMeterProperty)new BooleanProperty(PATH_EXTENSION_NO_EQUALS, pathExtNoEquals));
    }

    public boolean isPathExtension() {
        return this.getPropertyAsBoolean(PATH_EXTENSION);
    }

    public boolean isPathExtensionNoEquals() {
        return this.getPropertyAsBoolean(PATH_EXTENSION_NO_EQUALS);
    }

    public static class Test
    extends TestCase {
        SampleResult response;
        JMeterContext context;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.context = JMeterContextService.getContext();
        }

        public void testGrabSessionId() throws Exception {
            String html = "location: http://server.com/index.html?session_id=jfdkjdkf%20jddkfdfjkdjfdf%22;";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = this.createSampler();
            sampler.addArgument("session_id", "adfasdfdsafasdfasd");
            this.context.setCurrentSampler((Sampler)sampler);
            this.context.setPreviousResult(this.response);
            mod.process();
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkf jddkfdfjkdjfdf\"", (Object)((Argument)args.getArguments().get(0).getObjectValue()).getValue());
            Assert.assertEquals((Object)"http://server.com/index.html?session_id=jfdkjdkf+jddkfdfjkdjfdf%22", (Object)sampler.toString());
        }

        public void testGrabSessionId2() throws Exception {
            String html = "<a href=\"http://server.com/index.html?session_id=jfdkjdkfjddkfdfjkdjfdf\">";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = this.createSampler();
            this.context.setCurrentSampler((Sampler)sampler);
            this.context.setPreviousResult(this.response);
            mod.process();
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkfjddkfdfjkdjfdf", (Object)((Argument)args.getArguments().get(0).getObjectValue()).getValue());
        }

        private HTTPSampler createSampler() {
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("server.com");
            sampler.setPath("index.html");
            sampler.setMethod("GET");
            sampler.setProtocol("http");
            return sampler;
        }

        public void testGrabSessionId3() throws Exception {
            String html = "href='index.html?session_id=jfdkjdkfjddkfdfjkdjfdf'";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("session_id");
            HTTPSampler sampler = this.createSampler();
            this.context.setCurrentSampler((Sampler)sampler);
            this.context.setPreviousResult(this.response);
            mod.process();
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"jfdkjdkfjddkfdfjkdjfdf", (Object)((Argument)args.getArguments().get(0).getObjectValue()).getValue());
        }

        public void testGrabSessionId4() throws Exception {
            String html = "href='index.html;%24sid%24KQNq3AAADQZoEQAxlkX8uQV5bjqVBPbT'";
            this.response = new SampleResult();
            this.response.setResponseData(html.getBytes());
            URLRewritingModifier mod = new URLRewritingModifier();
            mod.setArgumentName("%24sid%24");
            mod.setPathExtension(true);
            mod.setPathExtensionNoEquals(true);
            HTTPSampler sampler = this.createSampler();
            this.context.setCurrentSampler((Sampler)sampler);
            this.context.setPreviousResult(this.response);
            mod.process();
            Arguments args = sampler.getArguments();
            Assert.assertEquals((Object)"index.html;%24sid%24KQNq3AAADQZoEQAxlkX8uQV5bjqVBPbT", (Object)sampler.getPath());
        }
    }
}

