/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.modifier.UserParameterXMLParser;
import org.apache.jmeter.protocol.http.modifier.UserSequence;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class UserParameterModifier
extends ConfigTestElement
implements PreProcessor,
Serializable,
TestListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final String XMLURI = "UserParameterModifier.xmluri";
    private UserSequence allAvailableUsers;

    public void testStarted() {
        List allUsers = new LinkedList();
        try {
            UserParameterXMLParser readXMLParameters = new UserParameterXMLParser();
            allUsers = readXMLParameters.getXMLParameters(this.getXmlUri());
        }
        catch (Exception e) {
            log.error("Unable to read parameters from xml file " + this.getXmlUri());
            log.error("No unique values for http requests will be substituted for each thread", (Throwable)e);
        }
        this.allAvailableUsers = new UserSequence(allUsers);
    }

    public void testEnded() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded(String host) {
    }

    public void process() {
        Sampler entry = JMeterContextService.getContext().getCurrentSampler();
        if (!(entry instanceof HTTPSampler)) {
            return;
        }
        HTTPSampler config = (HTTPSampler)entry;
        Map currentUser = this.allAvailableUsers.getNextUserMods();
        PropertyIterator iter = config.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next().getObjectValue();
            if (!currentUser.containsKey(arg.getName())) continue;
            arg.setValue((String)currentUser.get(arg.getName()));
        }
    }

    public String getXmlUri() {
        return this.getPropertyAsString(XMLURI);
    }

    public void setXmlUri(String xmlURI) {
        this.setProperty(XMLURI, xmlURI);
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    public Object clone() {
        UserParameterModifier clone = (UserParameterModifier)super.clone();
        clone.allAvailableUsers = this.allAvailableUsers;
        return clone;
    }
}

