/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.protocol.http.modifier.ParamMask;
import org.apache.jmeter.protocol.http.modifier.ParamModifier;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class ParamModifierGui
extends AbstractPreProcessorGui
implements FocusListener {
    private final String NAME = "name";
    private final String PREFIX = "prefix";
    private final String LOWERBOUND = "lowerBound";
    private final String UPPERBOUND = "upperBound";
    private final String INCREMENT = "increment";
    private final String SUFFIX = "suffix";
    private JTextField _fieldName;
    private JTextField _prefix;
    private JTextField _lowerBound;
    private JTextField _upperBound;
    private JTextField _increment;
    private JTextField _suffix;

    public ParamModifierGui() {
        this.init();
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"html_parameter_mask");
    }

    public void configure(TestElement el) {
        super.configure(el);
        ParamModifier model = (ParamModifier)el;
        this.updateGui(model);
    }

    public TestElement createTestElement() {
        ParamModifier modifier = new ParamModifier();
        this.modifyTestElement((TestElement)modifier);
        return modifier;
    }

    public void modifyTestElement(TestElement m) {
        this.configureTestElement(m);
        if (m instanceof ParamModifier) {
            ParamModifier modifier = (ParamModifier)m;
            ParamMask mask = modifier.getMask();
            mask.setFieldName(this._fieldName.getText());
            mask.setPrefix(this._prefix.getText());
            mask.setLowerBound(Long.parseLong(this._lowerBound.getText()));
            mask.setIncrement(Long.parseLong(this._increment.getText()));
            mask.setUpperBound(Long.parseLong(this._upperBound.getText()));
            mask.setSuffix(this._suffix.getText());
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
        String name = ((Component)evt.getSource()).getName();
        if (evt.isTemporary()) {
            return;
        }
        if (name.equals("lowerBound")) {
            this.checkTextField(evt, "0");
        } else if (name.equals("upperBound")) {
            this.checkTextField(evt, "0");
        } else if (name.equals("increment")) {
            this.checkTextField(evt, "0");
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.getParameterMaskPanel(), "Center");
    }

    private void updateGui(ParamModifier model) {
        this._fieldName.setText(model.getMask().getFieldName());
        this._prefix.setText(model.getMask().getPrefix());
        this._lowerBound.setText(Long.toString(model.getMask().getLowerBound()));
        this._upperBound.setText(Long.toString(model.getMask().getUpperBound()));
        this._increment.setText(Long.toString(model.getMask().getIncrement()));
        this._suffix.setText(model.getMask().getSuffix());
    }

    private JPanel createLabeledField(String labelResName, JTextField field) {
        JLabel label = new JLabel(JMeterUtils.getResString((String)labelResName));
        label.setLabelFor(field);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)field, "Center");
        return panel;
    }

    private JPanel getParameterMaskPanel() {
        HorizontalPanel panel = new HorizontalPanel(10, 0.0f);
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"HTML Parameter Mask")));
        this._fieldName = new JTextField(10);
        this._fieldName.setName("name");
        panel.add((Component)this.createLabeledField("Name", this._fieldName));
        this._prefix = new JTextField(5);
        this._prefix.setName("prefix");
        panel.add((Component)this.createLabeledField("ID Prefix", this._prefix));
        this._lowerBound = new JTextField("0", 5);
        this._lowerBound.addFocusListener(this);
        this._lowerBound.setName("lowerBound");
        panel.add((Component)this.createLabeledField("Lower Bound", this._lowerBound));
        this._upperBound = new JTextField("10", 5);
        this._upperBound.addFocusListener(this);
        this._upperBound.setName("upperBound");
        panel.add((Component)this.createLabeledField("Upper Bound", this._upperBound));
        this._increment = new JTextField("1", 3);
        this._increment.addFocusListener(this);
        this._increment.setName("increment");
        panel.add((Component)this.createLabeledField("Increment", this._increment));
        this._suffix = new JTextField(5);
        this._suffix.setName("suffix");
        panel.add((Component)this.createLabeledField("ID Suffix", this._suffix));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)panel, "North");
        return mainPanel;
    }

    private long checkTextField(FocusEvent evt, String defaultValue) {
        JTextField temp = (JTextField)evt.getSource();
        long longVal = 0L;
        try {
            longVal = Long.parseLong(temp.getText());
        }
        catch (NumberFormatException err) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This field must have a long value!", "Value Required", 0);
            temp.setText(defaultValue);
            temp.requestFocus();
        }
        return longVal;
    }
}

