/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.jmeter.protocol.http.proxy.Proxy;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Daemon
extends Thread {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private static final int DEFAULT_DAEMON_PORT = 8080;
    private static final int MAX_DAEMON_PORT = 65535;
    private static final int ACCEPT_TIMEOUT = 1000;
    private int daemonPort;
    private boolean running;
    private ProxyControl target;
    private Class proxyClass = class$org$apache$jmeter$protocol$http$proxy$Proxy == null ? (class$org$apache$jmeter$protocol$http$proxy$Proxy = Daemon.class$("org.apache.jmeter.protocol.http.proxy.Proxy")) : class$org$apache$jmeter$protocol$http$proxy$Proxy;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$proxy$Proxy;

    public Daemon() {
        super("HTTP Proxy Daemon");
    }

    public Daemon(int port, ProxyControl target) {
        this();
        this.target = target;
        this.configureProxy(port);
    }

    public Daemon(int port, ProxyControl target, Class proxyClass) {
        this(port, target);
        this.proxyClass = proxyClass;
    }

    public void configureProxy(int daemonPort) {
        this.daemonPort = daemonPort;
        log.info("Proxy: OK");
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("Usage: Daemon [daemon port]");
            log.info("Usage: Daemon [daemon port]");
            return;
        }
        int daemonPort = 8080;
        if (args.length > 0) {
            try {
                daemonPort = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid daemon port: " + e);
                log.error("Invalid daemon port", (Throwable)e);
                return;
            }
            if (daemonPort <= 0 || daemonPort > 65535) {
                System.err.println("Invalid daemon port");
                log.error("Invalid daemon port");
                return;
            }
        }
        Daemon demon = new Daemon();
        demon.configureProxy(daemonPort);
        demon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block14: {
            this.running = true;
            ServerSocket mainSocket = null;
            log.info("Creating Daemon Socket...");
            mainSocket = new ServerSocket(this.daemonPort);
            mainSocket.setSoTimeout(1000);
            log.info(" port " + this.daemonPort + " OK");
            log.info("Proxy up and running!");
            while (this.running) {
                try {
                    Socket clientSocket = mainSocket.accept();
                    if (this.running) {
                        Proxy thd = (Proxy)this.proxyClass.newInstance();
                        thd.configure(clientSocket, this.target);
                        thd.start();
                        continue;
                    }
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e) {}
                }
                catch (InterruptedIOException e) {
                    // empty catch block
                }
            }
            log.info("Proxy Server stopped");
            Object var5_7 = null;
            try {
                mainSocket.close();
            }
            catch (Exception exc) {}
            break block14;
            {
                catch (Exception e) {
                    log.warn("Proxy Server stopped", (Throwable)e);
                    Object var5_8 = null;
                    try {
                        mainSocket.close();
                    }
                    catch (Exception exc) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    mainSocket.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void stopServer() {
        this.running = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

