/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.proxy.HttpReplyHdr;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Proxy
extends Thread {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    private Socket clientSocket = null;
    private ProxyControl target;

    public Proxy() {
    }

    Proxy(Socket clientSocket, ProxyControl target) {
        this.configure(clientSocket, target);
    }

    void configure(Socket clientSocket, ProxyControl target) {
        this.target = target;
        this.clientSocket = clientSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block14: {
            HttpRequestHdr request = new HttpRequestHdr();
            byte[] serverResponse = new byte[]{};
            HeaderManager headers = new HeaderManager();
            HTTPSampler sampler = new HTTPSampler();
            byte[] clientRequest = request.parse(new BufferedInputStream(this.clientSocket.getInputStream()));
            headers = request.getHeaderManager();
            sampler = request.getSampler();
            sampler.setHeaderManager(headers);
            serverResponse = sampler.sample().getResponseData();
            this.writeToClient(serverResponse, new BufferedOutputStream(this.clientSocket.getOutputStream()));
            headers.removeHeaderNamed("cookie");
            this.target.deliverSampler(sampler, new TestElement[]{headers}, serverResponse);
            try {
                this.clientSocket.close();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            break block14;
            catch (UnknownHostException uhe) {
                log.warn("Server Not Found.", (Throwable)uhe);
                this.writeErrorToClient(HttpReplyHdr.formServerNotFound());
                this.target.deliverSampler(sampler, new TestElement[]{headers}, serverResponse);
                try {
                    this.clientSocket.close();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                this.writeErrorToClient(HttpReplyHdr.formTimeout());
                {
                    catch (Throwable throwable) {
                        this.target.deliverSampler(sampler, new TestElement[]{headers}, serverResponse);
                        try {
                            this.clientSocket.close();
                        }
                        catch (Exception e2) {
                            log.error("", (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                this.target.deliverSampler(sampler, new TestElement[]{headers}, serverResponse);
                try {
                    this.clientSocket.close();
                }
                catch (Exception e3) {
                    log.error("", (Throwable)e3);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private void writeToClient(byte[] inBytes, OutputStream out) throws IOException {
        block7: {
            out.write(inBytes);
            out.flush();
            log.info("Done writing to client");
            Object var5_3 = null;
            try {
                out.close();
            }
            catch (Exception ex) {
                log.warn("Error while closing socket", (Throwable)ex);
            }
            break block7;
            {
                catch (IOException e) {
                    log.error("", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    out.close();
                }
                catch (Exception ex) {
                    log.warn("Error while closing socket", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    private void writeErrorToClient(String message) {
        try {
            OutputStream sockOut = this.clientSocket.getOutputStream();
            DataOutputStream out = new DataOutputStream(sockOut);
            out.writeBytes(message);
            out.flush();
        }
        catch (Exception e) {
            log.warn("Exception while writing error", (Throwable)e);
        }
    }
}

