/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.proxy.Daemon;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ProxyControl
extends ConfigTestElement
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.http");
    Daemon server;
    private final int DEFAULT_PORT = 8080;
    private static PatternCacheLRU patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
    transient Perl5Matcher matcher = new Perl5Matcher();
    public static final String PORT = "ProxyControlGui.port";
    public static final String EXCLUDE_LIST = "ProxyControlGui.exclude_list";
    public static final String INCLUDE_LIST = "ProxyControlGui.include_list";
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$control$RecordingController;
    static /* synthetic */ Class class$org$apache$jmeter$threads$ThreadGroup;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$config$gui$UrlConfigGui;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$http$config$gui$HttpDefaultsGui;

    public ProxyControl() {
        this.setPort(8080);
        this.setExcludeList(new HashSet());
        this.setIncludeList(new HashSet());
    }

    public void setPort(int port) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, port));
    }

    public void setPort(String port) {
        this.setProperty(PORT, port);
    }

    public void setIncludeList(Collection list) {
        this.setProperty((JMeterProperty)new CollectionProperty(INCLUDE_LIST, new HashSet(list)));
    }

    public void setExcludeList(Collection list) {
        this.setProperty((JMeterProperty)new CollectionProperty(EXCLUDE_LIST, new HashSet(list)));
    }

    public String getClassLabel() {
        return JMeterUtils.getResString((String)"proxy_title");
    }

    public int getPort() {
        return this.getPropertyAsInt(PORT);
    }

    public int getDefaultPort() {
        return 8080;
    }

    public Class getGuiClass() {
        return class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui == null ? (class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui = ProxyControl.class$("org.apache.jmeter.protocol.http.proxy.gui.ProxyControlGui")) : class$org$apache$jmeter$protocol$http$proxy$gui$ProxyControlGui;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public void startProxy() {
        this.server = new Daemon(this.getPort(), this);
        this.server.start();
    }

    public void addExcludedPattern(String pattern) {
        this.getExcludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getExcludePatterns() {
        return (CollectionProperty)this.getProperty(EXCLUDE_LIST);
    }

    public void addIncludedPattern(String pattern) {
        this.getIncludePatterns().addItem((Object)pattern);
    }

    public CollectionProperty getIncludePatterns() {
        return (CollectionProperty)this.getProperty(INCLUDE_LIST);
    }

    public void clearExcludedPatterns() {
        this.getExcludePatterns().clear();
    }

    public void clearIncludedPatterns() {
        this.getIncludePatterns().clear();
    }

    public void deliverSampler(HTTPSampler sampler, TestElement[] subConfigs, byte[] serverResponse) {
        if (this.filterUrl(sampler)) {
            this.placeConfigElement(sampler, subConfigs);
        }
    }

    public void stopProxy() {
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    protected boolean filterUrl(HTTPSampler sampler) {
        boolean ok = false;
        if (sampler.getDomain() == null || sampler.getDomain().equals("")) {
            return false;
        }
        ok = this.getIncludePatterns().size() == 0 ? true : this.checkIncludes(sampler);
        if (!ok) {
            return ok;
        }
        if (this.getExcludePatterns().size() == 0) {
            return ok;
        }
        ok = this.checkExcludes(sampler);
        return ok;
    }

    private void placeConfigElement(HTTPSampler sampler, TestElement[] subConfigs) {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        TestElement urlConfig = null;
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        List nodes = treeModel.getNodesOfType(class$org$apache$jmeter$protocol$http$control$RecordingController == null ? (class$org$apache$jmeter$protocol$http$control$RecordingController = ProxyControl.class$("org.apache.jmeter.protocol.http.control.RecordingController")) : class$org$apache$jmeter$protocol$http$control$RecordingController);
        if (nodes.size() == 0) {
            nodes = treeModel.getNodesOfType(class$org$apache$jmeter$threads$ThreadGroup == null ? (class$org$apache$jmeter$threads$ThreadGroup = ProxyControl.class$("org.apache.jmeter.threads.ThreadGroup")) : class$org$apache$jmeter$threads$ThreadGroup);
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            JMeterTreeNode node = (JMeterTreeNode)iter.next();
            if (!node.isEnabled()) continue;
            Enumeration enumeration = node.children();
            String guiClassName = null;
            while (enumeration.hasMoreElements()) {
                JMeterTreeNode subNode = (JMeterTreeNode)enumeration.nextElement();
                TestElement sample = subNode.createTestElement();
                guiClassName = sample.getPropertyAsString("TestElement.gui_class");
                if (!guiClassName.equals((class$org$apache$jmeter$protocol$http$config$gui$UrlConfigGui == null ? ProxyControl.class$("org.apache.jmeter.protocol.http.config.gui.UrlConfigGui") : class$org$apache$jmeter$protocol$http$config$gui$UrlConfigGui).getName()) && !guiClassName.equals((class$org$apache$jmeter$protocol$http$config$gui$HttpDefaultsGui == null ? ProxyControl.class$("org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui") : class$org$apache$jmeter$protocol$http$config$gui$HttpDefaultsGui).getName())) continue;
                urlConfig = sample;
                break;
            }
            if (!this.areMatched(sampler, urlConfig)) continue;
            this.removeValuesFromSampler(sampler, urlConfig);
            this.replaceValues((TestElement)sampler, subConfigs);
            sampler.setProperty("TestElement.gui_class", "org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui");
            try {
                JMeterTreeNode newNode = treeModel.addComponent((TestElement)sampler, node);
                int i = 0;
                while (subConfigs != null && i < subConfigs.length) {
                    if (subConfigs[i] instanceof HeaderManager) {
                        subConfigs[i].setProperty("TestElement.gui_class", "org.apache.jmeter.protocol.http.gui.HeaderPanel");
                        treeModel.addComponent(subConfigs[i], newNode);
                    }
                    ++i;
                }
            }
            catch (IllegalUserActionException e) {
                JMeterUtils.reportErrorToUser((String)e.getMessage());
            }
        }
    }

    private void removeValuesFromSampler(HTTPSampler sampler, TestElement urlConfig) {
        if (urlConfig != null) {
            if (sampler.getDomain().equals(urlConfig.getPropertyAsString("HTTPSampler.domain"))) {
                sampler.setDomain("");
            }
            if (sampler.getPort() == urlConfig.getPropertyAsInt("HTTPSampler.port")) {
                sampler.setPort(0);
            }
            if (sampler.getPath().equals(urlConfig.getPropertyAsString("HTTPSampler.path"))) {
                sampler.setPath("");
            }
        }
    }

    private boolean areMatched(HTTPSampler sampler, TestElement urlConfig) {
        return urlConfig == null || (urlConfig.getPropertyAsString("HTTPSampler.domain").equals("") || urlConfig.getPropertyAsString("HTTPSampler.domain").equals(sampler.getDomain())) && (urlConfig.getPropertyAsString("HTTPSampler.path").equals("") || urlConfig.getPropertyAsString("HTTPSampler.path").equals(sampler.getPath()));
    }

    private boolean checkIncludes(HTTPSampler sampler) {
        boolean ok = false;
        PropertyIterator iter = this.getIncludePatterns().iterator();
        while (iter.hasNext()) {
            String item = iter.next().getStringValue();
            Pattern pattern = patternCache.getPattern(item, 0);
            StringBuffer url = new StringBuffer(sampler.getDomain());
            url.append(":");
            url.append(sampler.getPort());
            url.append(sampler.getPath());
            if (sampler.getQueryString().length() > 0) {
                url.append("?");
                url.append(sampler.getQueryString());
            }
            if (ok = this.matcher.matches(url.toString(), pattern)) break;
        }
        return ok;
    }

    private boolean checkExcludes(HTTPSampler sampler) {
        boolean ok = true;
        PropertyIterator iter = this.getExcludePatterns().iterator();
        while (iter.hasNext()) {
            String item = iter.next().getStringValue();
            Pattern pattern = patternCache.getPattern(item, 0);
            StringBuffer url = new StringBuffer(sampler.getDomain());
            url.append(":");
            url.append(sampler.getPort());
            url.append(sampler.getPath());
            if (sampler.getQueryString().length() > 0) {
                url.append("?");
                url.append(sampler.getQueryString());
            }
            boolean bl = ok = ok && !this.matcher.matches(url.toString(), pattern);
            if (ok) continue;
            return ok;
        }
        return ok;
    }

    protected void replaceValues(TestElement sampler, TestElement[] configs) {
        try {
            GuiPackage.getInstance().getReplacer().reverseReplace(sampler);
            int i = 0;
            while (i < configs.length) {
                GuiPackage.getInstance().getReplacer().reverseReplace(configs[i]);
                ++i;
            }
        }
        catch (InvalidVariableException e) {
            log.warn("Invalid variables included for replacement into recorded sample", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testFiltering() throws Exception {
            ProxyControl control = new ProxyControl();
            control.addIncludedPattern(".*\\.jsp");
            control.addExcludedPattern(".*apache.org.*");
            HTTPSampler sampler = new HTTPSampler();
            sampler.setDomain("jakarta.org");
            sampler.setPath("index.jsp");
            Assert.assertTrue((boolean)control.filterUrl(sampler));
            sampler.setDomain("www.apache.org");
            Assert.assertTrue((!control.filterUrl(sampler) ? 1 : 0) != 0);
            sampler.setPath("header.gif");
            sampler.setDomain("jakarta.org");
            Assert.assertTrue((!control.filterUrl(sampler) ? 1 : 0) != 0);
        }
    }
}

