/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ProxyControlGui
extends AbstractJMeterGuiComponent
implements JMeterGUIComponent,
ActionListener,
KeyListener,
FocusListener,
UnsharedComponent {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    private JTextField portField;
    private ProxyControl model;
    private JTable excludeTable;
    private PowerTableModel excludeModel;
    private JTable includeTable;
    private PowerTableModel includeModel;
    private JButton stop;
    private JButton start;
    private JButton restart;
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String RESTART = "restart";
    private static final String ADD_INCLUDE = "add_include";
    private static final String ADD_EXCLUDE = "add_exclude";
    private static final String DELETE_INCLUDE = "delete_include";
    private static final String DELETE_EXCLUDE = "delete_exclude";
    private static final String INCLUDE_COL = JMeterUtils.getResString((String)"patterns_to_include");
    private static final String EXCLUDE_COL = JMeterUtils.getResString((String)"patterns_to_exclude");
    static /* synthetic */ Class class$java$lang$String;

    public ProxyControlGui() {
        this.init();
    }

    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultTimerMenu();
    }

    public TestElement createTestElement() {
        if (this.model == null) {
            this.model = this.makeProxyControl();
        }
        log.debug("creating/configuring model = " + this.model);
        this.modifyTestElement((TestElement)this.model);
        return this.model;
    }

    protected ProxyControl makeProxyControl() {
        ProxyControl local = new ProxyControl();
        return local;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof ProxyControl) {
            ((ProxyControl)el).setPort(this.portField.getText());
            this.setIncludeListInProxyControl((ProxyControl)el);
            this.setExcludeListInProxyControl((ProxyControl)el);
            this.model = (ProxyControl)el;
        }
    }

    protected void setIncludeListInProxyControl(ProxyControl element) {
        List includeList = this.getDataList(this.includeModel, INCLUDE_COL);
        element.setIncludeList(includeList);
    }

    protected void setExcludeListInProxyControl(ProxyControl element) {
        List excludeList = this.getDataList(this.excludeModel, EXCLUDE_COL);
        element.setExcludeList(excludeList);
    }

    private List getDataList(PowerTableModel model, String colName) {
        String[] dataArray = model.getData().getColumn(colName);
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (i < dataArray.length) {
            list.add(dataArray[i]);
            ++i;
        }
        return list;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"proxy_title");
    }

    public Collection getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with " + element);
        super.configure(element);
        this.model = (ProxyControl)element;
        this.portField.setText(this.model.getPropertyAsString("ProxyControlGui.port"));
        this.populateTable(this.includeModel, this.model.getIncludePatterns().iterator());
        this.populateTable(this.excludeModel, this.model.getExcludePatterns().iterator());
        this.repaint();
    }

    private void populateTable(PowerTableModel model, PropertyIterator iter) {
        model.clearData();
        while (iter.hasNext()) {
            model.addRow(new Object[]{iter.next().getStringValue()});
        }
        model.fireTableDataChanged();
    }

    public void focusLost(FocusEvent e) {
        try {
            ((JTable)e.getSource()).getCellEditor().stopCellEditing();
        }
        catch (Exception err) {}
    }

    public void focusGained(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (command.equals(STOP)) {
            this.model.stopProxy();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
        } else if (command.equals(START)) {
            this.model = (ProxyControl)this.createTestElement();
            this.startProxy();
        } else if (command.equals(RESTART)) {
            this.model.stopProxy();
            this.model = (ProxyControl)this.createTestElement();
            this.startProxy();
        } else if (command.equals(ADD_EXCLUDE)) {
            this.excludeModel.addNewRow();
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_INCLUDE)) {
            this.includeModel.addNewRow();
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_EXCLUDE)) {
            this.excludeModel.removeRow(this.excludeTable.getSelectedRow());
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_INCLUDE)) {
            this.includeModel.removeRow(this.includeTable.getSelectedRow());
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        }
    }

    private void startProxy() {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        try {
            replacer.replaceValues((TestElement)this.model);
            this.model.startProxy();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.restart.setEnabled(false);
        }
        catch (InvalidVariableException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"invalid_variables"), "Error", 0);
        }
    }

    private void enableRestart() {
        if (this.stop.isEnabled()) {
            this.restart.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        block2: {
            String fieldName = e.getComponent().getName();
            if (!fieldName.equals("ProxyControlGui.port")) break block2;
            try {
                Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException nfe) {
                if (this.portField.getText().length() <= 0) break block2;
                JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid number", "Invalid data", 2);
                this.portField.setText("");
            }
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createPortPanel(), "North");
        Box includeExcludePanel = Box.createVerticalBox();
        includeExcludePanel.add(this.createIncludePanel());
        includeExcludePanel.add(this.createExcludePanel());
        mainPanel.add((Component)includeExcludePanel, "Center");
        mainPanel.add((Component)this.createControls(), "South");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString((String)START));
        this.start.addActionListener(this);
        this.start.setActionCommand(START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString((String)STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(STOP);
        this.stop.setEnabled(false);
        this.restart = new JButton(JMeterUtils.getResString((String)RESTART));
        this.restart.addActionListener(this);
        this.restart.setActionCommand(RESTART);
        this.restart.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        panel.add(this.restart);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField("8080", 8);
        this.portField.setName("ProxyControlGui.port");
        this.portField.addKeyListener(this);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.portField);
        return panel;
    }

    private JPanel createIncludePanel() {
        this.includeModel = new PowerTableModel(new String[]{INCLUDE_COL}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ProxyControlGui.class$("java.lang.String")) : class$java$lang$String});
        this.includeTable = new JTable((TableModel)this.includeModel);
        this.includeTable.setPreferredScrollableViewportSize(new Dimension(100, 50));
        this.includeTable.addFocusListener(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"patterns_to_include")));
        panel.add((Component)new JScrollPane(this.includeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_INCLUDE, DELETE_INCLUDE), "South");
        return panel;
    }

    private JPanel createExcludePanel() {
        this.excludeModel = new PowerTableModel(new String[]{EXCLUDE_COL}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ProxyControlGui.class$("java.lang.String")) : class$java$lang$String});
        this.excludeTable = new JTable((TableModel)this.excludeModel);
        this.excludeTable.setPreferredScrollableViewportSize(new Dimension(100, 50));
        this.excludeTable.addFocusListener(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"patterns_to_exclude")));
        panel.add((Component)new JScrollPane(this.excludeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_EXCLUDE, DELETE_EXCLUDE), "South");
        return panel;
    }

    private JPanel createTableButtonPanel(String addCommand, String deleteCommand) {
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton(JMeterUtils.getResString((String)"add"));
        addButton.setActionCommand(addCommand);
        addButton.addActionListener(this);
        buttonPanel.add(addButton);
        JButton deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        deleteButton.setActionCommand(deleteCommand);
        deleteButton.addActionListener(this);
        buttonPanel.add(deleteButton);
        return buttonPanel;
    }

    public void setNode(JMeterTreeNode node) {
        this.getNamePanel().setNode(node);
    }

    protected JTextField getPortField() {
        return this.portField;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

