/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFull;
import org.apache.jmeter.protocol.http.sampler.PostWriter;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class HTTPSampler
extends AbstractSampler {
    public static final String HEADERS = "headers";
    public static final String HEADER = "header";
    public static final String ARGUMENTS = "HTTPsampler.Arguments";
    public static final String AUTH_MANAGER = "HTTPSampler.auth_manager";
    public static final String COOKIE_MANAGER = "HTTPSampler.cookie_manager";
    public static final String HEADER_MANAGER = "HTTPSampler.header_manager";
    public static final String MIMETYPE = "HTTPSampler.mimetype";
    public static final String DOMAIN = "HTTPSampler.domain";
    public static final String PORT = "HTTPSampler.port";
    public static final String METHOD = "HTTPSampler.method";
    public static final String PATH = "HTTPSampler.path";
    public static final String FOLLOW_REDIRECTS = "HTTPSampler.follow_redirects";
    public static final String PROTOCOL = "HTTPSampler.protocol";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String URL = "HTTPSampler.URL";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String USE_KEEPALIVE = "HTTPSampler.use_keepalive";
    public static final String FILE_NAME = "HTTPSampler.FILE_NAME";
    public static final String FILE_FIELD = "HTTPSampler.FILE_FIELD";
    public static final String FILE_DATA = "HTTPSampler.FILE_DATA";
    public static final String FILE_MIMETYPE = "HTTPSampler.FILE_MIMETYPE";
    public static final String CONTENT_TYPE = "HTTPSampler.CONTENT_TYPE";
    public static final String NORMAL_FORM = "normal_form";
    public static final String MULTIPART_FORM = "multipart_form";
    public static final String ENCODED_PATH = "HTTPSampler.encoded_path";
    public static final String IMAGE_PARSER = "HTTPSampler.image_parser";
    public static final int UNSPECIFIED_PORT = 0;
    private static final int MAX_REDIRECTS = 10;
    protected static String encoding = "iso-8859-1";
    private static final PostWriter postWriter = new PostWriter();
    protected transient HttpURLConnection conn;
    private HTTPSamplerFull imageSampler;
    private static PatternCacheLRU patternCache;
    private static ThreadLocal localMatcher;
    private static Substitution spaceSub;
    private int connectionTries = 0;
    protected static final String NON_HTTP_RESPONSE_CODE = "Non HTTP response code";
    protected static final String NON_HTTP_RESPONSE_MESSAGE = "Non HTTP response message";
    private static transient Logger log;
    private ArrayList m_sampledURLs = new ArrayList();

    public void setFileField(String value) {
        this.setProperty(FILE_FIELD, value);
    }

    public String getFileField() {
        return this.getPropertyAsString(FILE_FIELD);
    }

    public void setFilename(String value) {
        this.setProperty(FILE_NAME, value);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILE_NAME);
    }

    public void setProtocol(String value) {
        this.setProperty(PROTOCOL, value);
    }

    public String getProtocol() {
        String protocol = this.getPropertyAsString(PROTOCOL);
        if (protocol == null || protocol.equals("")) {
            return DEFAULT_PROTOCOL;
        }
        return protocol;
    }

    public void setPath(String path) {
        if (GET.equals(this.getMethod())) {
            int index = path.indexOf("?");
            if (index > -1) {
                this.setProperty(PATH, path.substring(0, index));
                this.parseArguments(path.substring(index + 1));
            } else {
                this.setProperty(PATH, path);
            }
        } else {
            this.setProperty(PATH, path);
        }
    }

    public void setEncodedPath(String path) {
        path = this.encodePath(path);
        this.setProperty(ENCODED_PATH, path);
    }

    private String encodePath(String path) {
        path = Util.substitute((PatternMatcher)((Perl5Matcher)localMatcher.get()), (Pattern)patternCache.getPattern(" ", 0), (Substitution)spaceSub, (String)path, (int)-1);
        return path;
    }

    public String getEncodedPath() {
        return this.getPropertyAsString(ENCODED_PATH);
    }

    public void setProperty(JMeterProperty prop) {
        super.setProperty(prop);
        if (PATH.equals(prop.getName())) {
            this.setEncodedPath(prop.getStringValue());
        }
    }

    public void addProperty(JMeterProperty prop) {
        super.addProperty(prop);
        if (PATH.equals(prop.getName())) {
            super.addProperty((JMeterProperty)new StringProperty(ENCODED_PATH, this.encodePath(prop.getStringValue())));
        }
    }

    public String getPath() {
        return this.getPropertyAsString(PATH);
    }

    public void setFollowRedirects(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(FOLLOW_REDIRECTS, value));
    }

    public boolean getFollowRedirects() {
        return this.getPropertyAsBoolean(FOLLOW_REDIRECTS);
    }

    public void setMethod(String value) {
        this.setProperty(METHOD, value);
    }

    public String getMethod() {
        return this.getPropertyAsString(METHOD);
    }

    public void setUseKeepAlive(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_KEEPALIVE, value));
    }

    public boolean getUseKeepAlive() {
        return this.getPropertyAsBoolean(USE_KEEPALIVE);
    }

    public void addEncodedArgument(String name, String value, String metaData) {
        log.debug("adding argument: name: " + name + " value: " + value + " metaData: " + metaData);
        Arguments args = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, metaData, true);
        if (arg.getName().equals(arg.getEncodedName()) && arg.getValue().equals(arg.getEncodedValue())) {
            arg.setAlwaysEncoded(false);
        }
        args.addArgument((Argument)arg);
    }

    public void addArgument(String name, String value) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addTestElement(TestElement el) {
        if (el instanceof CookieManager) {
            this.setCookieManager((CookieManager)el);
        } else if (el instanceof HeaderManager) {
            this.setHeaderManager((HeaderManager)el);
        } else if (el instanceof AuthManager) {
            this.setAuthManager((AuthManager)el);
        } else {
            super.addTestElement(el);
        }
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments args = this.getArguments();
        args.addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public void setPort(int value) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, value));
    }

    public int getPort() {
        int port = this.getPropertyAsInt(PORT);
        if (port == 0) {
            if ("https".equalsIgnoreCase(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    public void setDomain(String value) {
        this.setProperty(DOMAIN, value);
    }

    public String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public void setArguments(Arguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)value));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setAuthManager(AuthManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(AUTH_MANAGER, (TestElement)value));
    }

    public AuthManager getAuthManager() {
        return (AuthManager)this.getProperty(AUTH_MANAGER).getObjectValue();
    }

    public void setHeaderManager(HeaderManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(HEADER_MANAGER, (TestElement)value));
    }

    public HeaderManager getHeaderManager() {
        return (HeaderManager)this.getProperty(HEADER_MANAGER).getObjectValue();
    }

    public void setCookieManager(CookieManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(COOKIE_MANAGER, (TestElement)value));
    }

    public CookieManager getCookieManager() {
        return (CookieManager)this.getProperty(COOKIE_MANAGER).getObjectValue();
    }

    public void setMimetype(String value) {
        this.setProperty(MIMETYPE, value);
    }

    public String getMimetype() {
        return this.getPropertyAsString(MIMETYPE);
    }

    public boolean isImageParser() {
        return this.getPropertyAsBoolean(IMAGE_PARSER);
    }

    public void setImageParser(boolean parseImages) {
        this.setProperty((JMeterProperty)new BooleanProperty(IMAGE_PARSER, parseImages));
    }

    public HTTPSampler() {
        this.setArguments(new Arguments());
    }

    public HTTPSampler(URL u) {
        this.setMethod(GET);
        this.setDomain(u.getHost());
        this.setPath(u.getPath());
        this.setPort(u.getPort());
        this.setProtocol(u.getProtocol());
        this.parseArguments(u.getQuery());
        this.setFollowRedirects(true);
        this.setUseKeepAlive(true);
        this.setArguments(new Arguments());
    }

    public SampleResult sample(Entry e) {
        return this.sample(0);
    }

    public SampleResult sample() {
        return this.sample(0);
    }

    public URL getUrl() throws MalformedURLException {
        String pathAndQuery = null;
        pathAndQuery = this.getMethod().equals(GET) && this.getQueryString().length() > 0 ? (this.getEncodedPath().indexOf("?") > -1 ? this.getEncodedPath() + "&" + this.getQueryString() : this.getEncodedPath() + "?" + this.getQueryString()) : this.getEncodedPath();
        if (!pathAndQuery.startsWith("/")) {
            pathAndQuery = "/" + pathAndQuery;
        }
        if (this.getPort() == 0 || this.getPort() == 80) {
            return new URL(this.getProtocol(), this.getDomain(), pathAndQuery);
        }
        return new URL(this.getProtocol(), this.getPropertyAsString(DOMAIN), this.getPort(), pathAndQuery);
    }

    public String getQueryString() {
        StringBuffer buf = new StringBuffer();
        PropertyIterator iter = this.getArguments().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            HTTPArgument item = null;
            try {
                item = (HTTPArgument)iter.next().getObjectValue();
            }
            catch (ClassCastException e) {
                item = new HTTPArgument((Argument)iter.next().getObjectValue());
            }
            if (!first) {
                buf.append("&");
            } else {
                first = false;
            }
            buf.append(item.getEncodedName());
            if (item.getMetaData() == null) {
                buf.append("=");
            } else {
                buf.append(item.getMetaData());
            }
            buf.append(item.getEncodedValue());
        }
        return buf.toString();
    }

    public void setPostHeaders(URLConnection conn) throws IOException {
        postWriter.setHeaders(conn, this);
    }

    public void sendPostData(URLConnection connection) throws IOException {
        postWriter.sendPostData(connection, this);
    }

    protected HttpURLConnection setupConnection(URL u, String method, SampleResult res) throws IOException {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        if ("https".equals(u.getProtocol())) {
            try {
                SSLManager.getInstance().setContext(conn);
            }
            catch (Exception e) {
                log.warn("You may have forgotten to set the ssl.provider property in jmeter.properties", (Throwable)e);
            }
        }
        if (this.getUseKeepAlive()) {
            conn.setRequestProperty("Connection", "keep-alive");
        } else {
            conn.setRequestProperty("Connection", "close");
        }
        conn.setRequestMethod(method);
        this.setConnectionHeaders(conn, u, this.getHeaderManager());
        String cookies = this.setConnectionCookie(conn, u, this.getCookieManager());
        if (res != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.toString());
            sb.append("\nCookie Data:\n");
            sb.append(cookies);
            res.setSamplerData(sb.toString());
        }
        this.setConnectionAuthorization(conn, u, this.getAuthManager());
        return conn;
    }

    public void parseArguments(String queryString) {
        String[] args = JOrphanUtils.split((String)queryString, (String)"&");
        int i = 0;
        while (i < args.length) {
            int endOfNameIndex = 0;
            String metaData = "";
            if (args[i].indexOf("=") != -1) {
                endOfNameIndex = args[i].indexOf("=");
                metaData = "=";
            } else {
                metaData = "";
                endOfNameIndex = args[i].length() > 0 ? args[i].length() : 0;
            }
            String name = "";
            if (args[i].length() > 0) {
                name = args[i].substring(0, endOfNameIndex);
            }
            String value = "";
            if (endOfNameIndex + 1 < args[i].length()) {
                value = args[i].substring(endOfNameIndex + 1, args[i].length());
            }
            if (name.length() > 0) {
                try {
                    this.addEncodedArgument(name, value, metaData);
                }
                catch (Exception e) {
                    log.error("UrlConfig:parseArguments(): Unable to parse argument=[" + value + "]");
                    log.error("UrlConfig:parseArguments(): queryString=[" + queryString + "]", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected byte[] readResponse(HttpURLConnection conn) throws IOException {
        BufferedInputStream in;
        byte[] readBuffer = JMeterContextService.getContext().getReadBuffer();
        try {
            in = conn.getContentEncoding() != null && conn.getContentEncoding().equals("gzip") ? new BufferedInputStream(new GZIPInputStream(conn.getInputStream())) : new BufferedInputStream(conn.getInputStream());
        }
        catch (Exception e) {
            log.info("Getting error message from server", (Throwable)e);
            in = new BufferedInputStream(conn.getErrorStream());
        }
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        int x = 0;
        while ((x = in.read(readBuffer)) > -1) {
            w.write(readBuffer, 0, x);
        }
        in.close();
        w.flush();
        w.close();
        return w.toByteArray();
    }

    protected byte[] getResponseHeaders(HttpURLConnection conn, SampleResult res) throws IOException {
        StringBuffer headerBuf = new StringBuffer();
        headerBuf.append(conn.getHeaderField(0).substring(0, 8));
        headerBuf.append(" ");
        headerBuf.append(conn.getResponseCode());
        headerBuf.append(" ");
        headerBuf.append(conn.getResponseMessage());
        headerBuf.append("\n");
        int i = 1;
        while (conn.getHeaderFieldKey(i) != null) {
            if (!conn.getHeaderFieldKey(i).equalsIgnoreCase("transfer-encoding")) {
                headerBuf.append(conn.getHeaderFieldKey(i));
                headerBuf.append(": ");
                headerBuf.append(conn.getHeaderField(i));
                headerBuf.append("\n");
            }
            ++i;
        }
        headerBuf.append("\n");
        return headerBuf.toString().getBytes("8859_1");
    }

    private String setConnectionCookie(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(u)) != null) {
            conn.setRequestProperty("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    private void setConnectionHeaders(HttpURLConnection conn, URL u, HeaderManager headerManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            PropertyIterator i = headers.iterator();
            while (i.hasNext()) {
                Header header = (Header)i.next().getObjectValue();
                conn.setRequestProperty(header.getName(), header.getValue());
            }
        }
    }

    private void setConnectionAuthorization(HttpURLConnection conn, URL u, AuthManager authManager) {
        String authHeader;
        if (authManager != null && (authHeader = authManager.getAuthHeaderForURL(u)) != null) {
            conn.setRequestProperty("Authorization", authHeader);
        }
    }

    private int getErrorLevel(HttpURLConnection conn, SampleResult res, long time) throws IOException {
        int errorLevel = 200;
        String message = null;
        errorLevel = conn.getResponseCode();
        message = conn.getResponseMessage();
        res.setResponseCode(Integer.toString(errorLevel));
        res.setResponseMessage(message);
        return errorLevel;
    }

    public void removeArguments() {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)new Arguments()));
    }

    private void redirectUrl(HttpURLConnection conn, URL u) throws MalformedURLException {
        String loc = conn.getHeaderField("Location");
        if (loc != null && loc.indexOf(DEFAULT_PROTOCOL) == -1) {
            String tempURL = u.toString();
            if (loc.startsWith("/")) {
                int ind = tempURL.indexOf("//") + 2;
                loc = tempURL.substring(0, tempURL.indexOf("/", ind) + 1) + loc.substring(1);
            } else {
                loc = u.toString().substring(0, u.toString().lastIndexOf(47) + 1) + loc;
            }
        }
        URL newUrl = new URL(loc);
        this.setMethod(GET);
        this.setProtocol(newUrl.getProtocol());
        this.setDomain(newUrl.getHost());
        this.setPort(newUrl.getPort());
        this.setPath(newUrl.getFile());
        this.removeArguments();
        this.parseArguments(newUrl.getQuery());
    }

    protected long connect() throws IOException {
        long time = System.currentTimeMillis();
        try {
            this.conn.connect();
            this.connectionTries = 0;
        }
        catch (BindException e) {
            log.debug("Bind exception, try again");
            if (this.connectionTries++ == 10) {
                log.error("Can't connect", (Throwable)e);
                throw e;
            }
            this.conn.disconnect();
            this.conn = null;
            System.gc();
            Runtime.getRuntime().runFinalization();
            this.setUseKeepAlive(false);
            this.conn = this.setupConnection(this.getUrl(), this.getMethod(), null);
            if (this.getMethod().equals(POST)) {
                this.setPostHeaders(this.conn);
            }
            time = this.connect();
        }
        catch (IOException e) {
            log.debug("Connection failed, giving up");
            this.conn.disconnect();
            this.conn = null;
            System.gc();
            Runtime.getRuntime().runFinalization();
            throw e;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private SampleResult sample(int redirects) {
        log.debug("Start : sample2");
        long time = System.currentTimeMillis();
        SampleResult res = new SampleResult();
        log.debug("#4, encoded path = " + this.getEncodedPath());
        URL u = null;
        u = this.getUrl();
        res.setSampleLabel(this.getName());
        if (log.isDebugEnabled()) {
            log.debug("sample2 : sampling url - " + u);
        }
        this.conn = this.setupConnection(u, this.getMethod(), res);
        if (this.getMethod().equals(POST)) {
            this.setPostHeaders(this.conn);
            time = this.connect();
            this.sendPostData(this.conn);
        } else {
            time = this.connect();
        }
        this.saveConnectionCookies(this.conn, u, this.getCookieManager());
        int errorLevel = 0;
        try {
            errorLevel = this.getErrorLevel(this.conn, res, time);
        }
        catch (IOException e) {
            time = this.bundleResponseInResult(time, res, this.conn);
            res.setSuccessful(false);
            res.setTime(time);
            SampleResult sampleResult = res;
            Object var10_10 = null;
            try {
                this.disconnect(this.conn);
            }
            catch (Exception e2) {
                // empty catch block
            }
            return sampleResult;
        }
        if (errorLevel / 100 == 2 || errorLevel == 304) {
            time = this.bundleResponseInResult(time, res, this.conn);
        } else if (errorLevel / 100 == 3) {
            if (redirects >= 10) {
                throw new IOException("Maximum number of redirects exceeded");
            }
            if (!this.getFollowRedirects()) {
                time = this.bundleResponseInResult(time, res, this.conn);
            } else {
                time = this.bundleResponseInResult(time, res, this.conn);
                this.redirectUrl(this.conn, u);
                SampleResult redirectResult = this.sample(redirects + 1);
                res.addSubResult(redirectResult);
                res.setSuccessful(redirectResult.isSuccessful());
                time += redirectResult.getTime();
            }
        } else {
            time = this.bundleResponseInResult(time, res, this.conn);
            res.setSuccessful(false);
        }
        res.setTime(time);
        log.debug("End : sample2");
        if (this.isImageParser()) {
            if (this.imageSampler == null) {
                this.imageSampler = new HTTPSamplerFull();
            }
            res = this.imageSampler.parseForImages(res, this);
        }
        SampleResult sampleResult = res;
        Object var10_11 = null;
        try {
            this.disconnect(this.conn);
        }
        catch (Exception e2) {
            // empty catch block
        }
        return sampleResult;
        catch (Exception ex) {
            try {
                log.warn(ex.getMessage(), (Throwable)ex);
                res.setDataType("text");
                res.setResponseData(ex.toString().getBytes());
                res.setResponseCode(NON_HTTP_RESPONSE_CODE);
                res.setResponseMessage(NON_HTTP_RESPONSE_MESSAGE);
                res.setTime(System.currentTimeMillis() - time);
                res.setSuccessful(false);
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    this.disconnect(this.conn);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.disconnect(this.conn);
            }
            catch (Exception e2) {}
        }
        log.debug("End : sample2");
        return res;
    }

    protected void disconnect(HttpURLConnection conn) {
        String connection = conn.getHeaderField("Connection");
        boolean http11 = conn.getHeaderField(0).startsWith("HTTP/1.1");
        if (connection == null && !http11 || connection != null && connection.equalsIgnoreCase("close")) {
            conn.disconnect();
        }
    }

    private long bundleResponseInResult(long time, SampleResult res, HttpURLConnection conn) throws IOException, FileNotFoundException {
        res.setDataType("text");
        byte[] ret = this.readResponse(conn);
        byte[] head = this.getResponseHeaders(conn, res);
        time = System.currentTimeMillis() - time;
        byte[] complete = new byte[ret.length + head.length];
        System.arraycopy(head, 0, complete, 0, head.length);
        System.arraycopy(ret, 0, complete, head.length, ret.length);
        res.setResponseData(complete);
        res.setSuccessful(true);
        return time;
    }

    private void saveConnectionCookies(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            int i = 1;
            while (conn.getHeaderFieldKey(i) != null) {
                if (conn.getHeaderFieldKey(i).equalsIgnoreCase("set-cookie")) {
                    cookieManager.addCookieFromHeader(conn.getHeaderField(i), u);
                }
                ++i;
            }
        }
    }

    public String toString() {
        try {
            return this.getUrl().toString() + (POST.equals(this.getMethod()) ? "\nQuery Data: " + this.getQueryString() : "");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", JMeterUtils.getPropDefault((String)"ssl.pkgs", (String)"com.sun.net.ssl.internal.www.protocol"));
        System.setProperty("javax.net.ssl.debug", "all");
        patternCache = new PatternCacheLRU(1000, (PatternCompiler)new Perl5Compiler());
        localMatcher = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Perl5Matcher();
            }
        };
        spaceSub = new StringSubstitution("%20");
        log = LoggingManager.getLoggerForClass();
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testArgumentWithoutEquals() throws Exception {
            HTTPSampler sampler = new HTTPSampler();
            sampler.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            sampler.setMethod(HTTPSampler.GET);
            sampler.setPath("/index.html?pear");
            sampler.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?pear", (Object)sampler.getUrl().toString());
        }

        public void testMakingUrl() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl2() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1");
            config.setPath("/index.html?p1=p2");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=value1&p1=p2", (Object)config.getUrl().toString());
        }

        public void testMakingUrl3() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.POST);
            config.addArgument("param1", "value1");
            config.setPath("/index.html?p1=p2");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?p1=p2", (Object)config.getUrl().toString());
        }

        public void testMakingUrl4() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "value1", "=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl5() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "", "=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=", (Object)config.getUrl().toString());
        }

        public void testMakingUrl6() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.addArgument("param1", "", "");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl7() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1=value1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=value1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl8() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1=");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1=", (Object)config.getUrl().toString());
        }

        public void testMakingUrl9() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("param1");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html?param1", (Object)config.getUrl().toString());
        }

        public void testMakingUrl10() throws Exception {
            HTTPSampler config = new HTTPSampler();
            config.setProtocol(HTTPSampler.DEFAULT_PROTOCOL);
            config.setMethod(HTTPSampler.GET);
            config.parseArguments("");
            config.setPath("/index.html");
            config.setDomain("www.apache.org");
            Assert.assertEquals((Object)"http://www.apache.org/index.html", (Object)config.getUrl().toString());
        }
    }
}

