/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SoapSampler
extends HTTPSampler {
    private static Logger log = LoggingManager.getLoggerForClass();
    public static final String XML_DATA = "HTTPSamper.xml_data";
    public static final String URL_DATA = "SoapSampler.URL_DATA";

    public void setXmlData(String data) {
        this.setProperty(XML_DATA, data);
    }

    public String getXmlData() {
        return this.getPropertyAsString(XML_DATA);
    }

    public String getURLData() {
        return this.getPropertyAsString(URL_DATA);
    }

    public void setURLData(String url) {
        this.setProperty(URL_DATA, url);
    }

    public void setPostHeaders(URLConnection connection) throws IOException {
        ((HttpURLConnection)connection).setRequestMethod("POST");
        connection.setRequestProperty("Content-length", "" + this.getXmlData().length());
        connection.setRequestProperty("Content-type", "text/xml");
        connection.setDoOutput(true);
    }

    public void sendPostData(URLConnection connection) throws IOException {
        PrintWriter out = new PrintWriter(connection.getOutputStream());
        out.print(this.getXmlData());
        out.close();
    }

    public SampleResult sample(Entry e) {
        block3: {
            try {
                URL url = new URL(this.getURLData());
                this.setDomain(url.getHost());
                this.setPort(url.getPort());
                this.setProtocol(url.getProtocol());
                this.setMethod("POST");
                if (url.getQuery() != null && url.getQuery().compareTo("") != 0) {
                    this.setPath(url.getPath() + "?" + url.getQuery());
                    break block3;
                }
                this.setPath(url.getPath());
            }
            catch (MalformedURLException e1) {
                log.error("Bad url: " + this.getURLData(), (Throwable)e1);
            }
        }
        return super.sample(e);
    }

    public String toString() {
        try {
            String xml = this.getXmlData();
            if (xml.length() > 100) {
                xml = xml.substring(0, 100);
            }
            return this.getUrl().toString() + "\nXML Data: " + xml;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }
}

