/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.DOMPool;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.io.TextFile;
import org.apache.soap.Envelope;
import org.apache.soap.messaging.Message;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WebServiceSampler
extends HTTPSampler {
    public static final String XML_DATA = "HTTPSamper.xml_data";
    public static final String SOAP_ACTION = "Soap.Action";
    public static final String XML_DATA_FILE = "WebServiceSampler.xml_data_file";
    public static final String XML_PATH_LOC = "WebServiceSampler.xml_path_loc";
    public static final String MEMORY_CACHE = "WebServiceSampler.memory_cache";
    public static final String READ_RESPONSE = "WebServiceSampler.read_response";
    protected String SOAPACTION = null;
    transient SampleResult RESULT = null;
    protected Document XMLMSG = null;
    private int FILE_COUNT = -1;
    private File[] FILE_LIST = null;
    private Random RANDOM = new Random();
    protected static DocumentBuilder XDB = null;

    public void setXmlPathLoc(String path) {
        this.setProperty(XML_PATH_LOC, path);
    }

    public String getXmlPathLoc() {
        return this.getPropertyAsString(XML_PATH_LOC);
    }

    public void setXmlFile(String filename) {
        this.setProperty(XML_DATA_FILE, filename);
    }

    public String getXmlFile() {
        return this.getPropertyAsString(XML_DATA_FILE);
    }

    private String retrieveRuntimeXmlData() {
        TextFile contents;
        String file = this.getRandomFileName();
        if (file.length() > 0 && (contents = new TextFile(file)).exists()) {
            return contents.getText();
        }
        return this.getXmlData();
    }

    protected String getRandomFileName() {
        if (this.getXmlPathLoc() != null) {
            File src = new File(this.getXmlPathLoc());
            if (src.isDirectory() && src.list() != null) {
                this.FILE_LIST = src.listFiles((FileFilter)new JMeterFileFilter(new String[]{".xml"}));
                this.FILE_COUNT = this.FILE_LIST.length;
                File one = this.FILE_LIST[this.RANDOM.nextInt(this.FILE_COUNT)];
                return one.getAbsolutePath();
            }
            return this.getXmlFile();
        }
        return this.getXmlFile();
    }

    public void setXmlData(String data) {
        this.setProperty(XML_DATA, data);
    }

    public String getXmlData() {
        return this.getPropertyAsString(XML_DATA);
    }

    public void setSoapAction(String data) {
        this.setProperty(SOAP_ACTION, data);
    }

    public String getSoapAction() {
        return this.getPropertyAsString(SOAP_ACTION);
    }

    public void setMemoryCache(boolean cache) {
        this.setProperty(MEMORY_CACHE, String.valueOf(cache));
    }

    public boolean getMemoryCache() {
        return this.getPropertyAsBoolean(MEMORY_CACHE);
    }

    public void setReadResponse(boolean read) {
        this.setProperty(READ_RESPONSE, String.valueOf(read));
    }

    public boolean getReadResponse() {
        return this.getPropertyAsBoolean(READ_RESPONSE);
    }

    public Element createDocument() {
        if (this.getPropertyAsBoolean(MEMORY_CACHE)) {
            String next = this.getRandomFileName();
            if (DOMPool.getDocument(next) != null) {
                return DOMPool.getDocument(next).getDocumentElement();
            }
            return this.openDocument(next).getDocumentElement();
        }
        return this.openDocument(null).getDocumentElement();
    }

    protected Document openDocument(String key) {
        String xmlData = this.retrieveRuntimeXmlData();
        if (xmlData != null && xmlData.length() > 0) {
            Document doc = null;
            try {
                if (XDB == null) {
                    XDB = XMLParserUtils.getXMLDocBuilder();
                }
                doc = XDB.parse(new InputSource(new StringReader(xmlData)));
                if (this.getPropertyAsBoolean(MEMORY_CACHE)) {
                    DOMPool.putDocument(key, doc);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return doc;
        }
        return null;
    }

    public SampleResult sample(Entry e) {
        return this.sample();
    }

    public SampleResult sample() {
        this.RESULT = new SampleResult();
        this.sampleWithApache();
        return this.RESULT;
    }

    /*
     * WARNING - void declaration
     */
    public void sampleWithApache() {
        try {
            Envelope msgEnv = Envelope.unmarshall((Node)this.createDocument());
            Message msg = new Message();
            long start = System.currentTimeMillis();
            msg.send(this.getUrl(), this.getSoapAction(), msgEnv);
            SOAPTransport st = msg.getSOAPTransport();
            BufferedReader br = st.receive();
            this.RESULT.setDataType("text");
            if (this.getPropertyAsBoolean(READ_RESPONSE)) {
                String line;
                StringBuffer buf = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    void var8_8;
                    buf.append((String)var8_8);
                }
                this.RESULT.setTime(System.currentTimeMillis() - start);
                this.RESULT.setResponseData(buf.toString().getBytes());
            } else {
                br.read();
                this.RESULT.setTime(System.currentTimeMillis() - start);
                this.RESULT.setResponseData(JMeterUtils.getResString((String)"read_response_message").getBytes());
            }
            this.RESULT.setTimeStamp(System.currentTimeMillis());
            this.RESULT.setSuccessful(true);
            this.RESULT.setSamplerData(this.getUrl().getProtocol() + "://" + this.getUrl().getHost() + "/" + this.getUrl().getFile());
            this.RESULT.setDataEncoding(st.getResponseSOAPContext().getContentType());
            this.RESULT.setResponseCode("200");
            br.close();
            msg = null;
            st = null;
        }
        catch (Exception exception) {
            this.RESULT.setSuccessful(false);
        }
    }

    public void addEncodedArgument(String name, String value, String metaData) {
    }

    protected HttpURLConnection setupConnection(URL u, String method) throws IOException {
        return null;
    }

    protected long connect() throws IOException {
        return -1L;
    }
}

