/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.EncoderCache;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class HTTPArgument
extends Argument
implements Serializable {
    private static final String ALWAYS_ENCODE = "HTTPArgument.always_encode";
    private static final String USE_EQUALS = "HTTPArgument.use_equals";
    private static EncoderCache cache = new EncoderCache(1000);

    public HTTPArgument(String name, String value, String metadata) {
        this(name, value, false);
        this.setMetaData(metadata);
    }

    public void setUseEquals(boolean ue) {
        if (ue) {
            this.setMetaData("=");
        } else {
            this.setMetaData("");
        }
        this.setProperty((JMeterProperty)new BooleanProperty(USE_EQUALS, ue));
    }

    public boolean isUseEquals() {
        boolean eq = this.getPropertyAsBoolean(USE_EQUALS);
        if (this.getMetaData().equals("=") || this.getValue() != null && this.getValue().toString().length() > 0) {
            this.setUseEquals(true);
            return true;
        }
        return eq;
    }

    public void setAlwaysEncoded(boolean ae) {
        this.setProperty((JMeterProperty)new BooleanProperty(ALWAYS_ENCODE, ae));
    }

    public boolean isAlwaysEncoded() {
        return this.getPropertyAsBoolean(ALWAYS_ENCODE);
    }

    public HTTPArgument(String name, String value) {
        this(name, value, false);
    }

    public HTTPArgument(String name, String value, boolean alreadyEncoded) {
        this.setAlwaysEncoded(true);
        if (alreadyEncoded) {
            name = URLDecoder.decode(name);
            value = URLDecoder.decode(value.toString());
        }
        this.setName(name);
        this.setValue(value);
        this.setMetaData("=");
    }

    public HTTPArgument(String name, String value, String metaData, boolean alreadyEncoded) {
        this(name, value, alreadyEncoded);
        this.setMetaData(metaData);
    }

    public HTTPArgument(Argument arg) {
        this(arg.getName(), arg.getValue(), arg.getMetaData());
    }

    public HTTPArgument() {
    }

    public void setName(String newName) {
        if (newName == null || !newName.equals(this.getName())) {
            super.setName(newName);
        }
    }

    public String getEncodedValue() {
        if (this.isAlwaysEncoded()) {
            return cache.getEncoded(this.getValue());
        }
        return this.getValue();
    }

    public String getEncodedName() {
        if (this.isAlwaysEncoded()) {
            return cache.getEncoded(this.getName());
        }
        return this.getName();
    }

    public static void convertArgumentsToHTTP(Arguments args) {
        LinkedList<Argument> newArguments = new LinkedList<Argument>();
        PropertyIterator iter = args.getArguments().iterator();
        while (iter.hasNext()) {
            Argument arg = (Argument)iter.next().getObjectValue();
            if (!(arg instanceof HTTPArgument)) {
                newArguments.add(new HTTPArgument(arg));
                continue;
            }
            newArguments.add(arg);
        }
        args.removeAllArguments();
        args.setArguments(newArguments);
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testCloning() throws Exception {
            HTTPArgument arg = new HTTPArgument("name.?", "value_ here");
            Assert.assertEquals((Object)"name.%3F", (Object)arg.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)arg.getEncodedValue());
            HTTPArgument clone = (HTTPArgument)arg.clone();
            Assert.assertEquals((Object)"name.%3F", (Object)clone.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)clone.getEncodedValue());
        }

        public void testConversion() throws Exception {
            Arguments args = new Arguments();
            args.addArgument("name.?", "value_ here");
            args.addArgument("name$of property", "value_.+");
            HTTPArgument.convertArgumentsToHTTP(args);
            CollectionProperty argList = args.getArguments();
            HTTPArgument httpArg = (HTTPArgument)argList.get(0).getObjectValue();
            Assert.assertEquals((Object)"name.%3F", (Object)httpArg.getEncodedName());
            Assert.assertEquals((Object)"value_+here", (Object)httpArg.getEncodedValue());
            httpArg = (HTTPArgument)argList.get(1).getObjectValue();
            Assert.assertEquals((Object)"name%24of+property", (Object)httpArg.getEncodedName());
            Assert.assertEquals((Object)"value_.%2B", (Object)httpArg.getEncodedValue());
        }
    }
}

