/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jmeter.protocol.http.util.WSDLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLHelper {
    protected URL WSDLURL = null;
    protected HttpURLConnection CONN = null;
    protected Document WSDLDOC = null;
    protected String SOAPBINDING = null;
    public String BINDNAME = null;
    protected Object[] SOAPOPS = null;
    protected HashMap ACTIONS = new HashMap();

    public WSDLHelper(String url) throws MalformedURLException {
        this.WSDLURL = new URL(url);
    }

    public URL getURL() {
        return this.WSDLURL;
    }

    public String getBinding() {
        try {
            NodeList services = this.WSDLDOC.getElementsByTagName("service");
            Element node = (Element)services.item(0);
            NodeList ports = node.getElementsByTagName("port");
            int idx = 0;
            while (idx < ports.getLength()) {
                Element pnode = (Element)ports.item(idx);
                String portname = pnode.getAttribute("name");
                if (portname.equals(this.BINDNAME)) {
                    NodeList servlist = pnode.getElementsByTagName("soap:address");
                    Element addr = (Element)servlist.item(0);
                    this.SOAPBINDING = addr.getAttribute("location");
                    return this.SOAPBINDING;
                }
                ++idx;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void connect() throws IOException {
        this.CONN = (HttpURLConnection)this.WSDLURL.openConnection();
    }

    protected void close() {
        try {
            this.CONN.getInputStream().close();
        }
        catch (Exception exception) {}
    }

    protected void buildDocument() throws ParserConfigurationException, IOException, SAXException {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuild = dbfactory.newDocumentBuilder();
            this.WSDLDOC = docbuild.parse(this.CONN.getInputStream());
        }
        catch (ParserConfigurationException exception) {
            throw exception;
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (SAXException exception) {
            throw exception;
        }
    }

    public void parse() throws WSDLException {
        try {
            this.connect();
            this.buildDocument();
            this.SOAPOPS = this.getOperations();
            this.close();
        }
        catch (IOException exception) {
            throw new WSDLException(exception);
        }
        catch (Exception exception) {
            throw new WSDLException(exception);
        }
    }

    public String[] getWebMethods() {
        int idx = 0;
        while (idx < this.SOAPOPS.length) {
            Node act = (Node)this.SOAPOPS[idx];
            NodeList opers = ((Element)act).getElementsByTagName("soap:operation");
            Element op = (Element)opers.item(0);
            String value = op.getAttribute("soapAction");
            String key = ((Element)act).getAttribute("name");
            this.ACTIONS.put(key, value);
            ++idx;
        }
        Set keys = this.ACTIONS.keySet();
        String[] stringmeth = new String[keys.size()];
        Object[] stringKeys = keys.toArray();
        System.arraycopy(stringKeys, 0, stringmeth, 0, keys.size());
        return stringmeth;
    }

    public String getSoapAction(String key) {
        return (String)this.ACTIONS.get(key);
    }

    public Document getWSDLDocument() {
        return this.WSDLDOC;
    }

    public Object[] getSOAPBindings() {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList bindings = this.WSDLDOC.getElementsByTagName("binding");
        int idx = 0;
        while (idx < bindings.getLength()) {
            Element nd = (Element)bindings.item(idx);
            NodeList slist = nd.getElementsByTagName("soap:binding");
            if (slist.getLength() > 0) {
                Element soapbind = (Element)slist.item(0);
                this.BINDNAME = nd.getAttribute("name");
                list.add(nd);
            }
            ++idx;
        }
        if (list.size() > 0) {
            return list.toArray();
        }
        return new Object[0];
    }

    public Object[] getOperations() {
        Object[] res = this.getSOAPBindings();
        ArrayList<Element> ops = new ArrayList<Element>();
        int idx = 0;
        while (idx < res.length) {
            Element one = (Element)res[idx];
            NodeList opnodes = one.getElementsByTagName("operation");
            int idz = 0;
            while (idz < opnodes.getLength()) {
                Element child = (Element)opnodes.item(idz);
                NodeList soapnode = child.getElementsByTagName("soap:operation");
                if (soapnode.getLength() > 0) {
                    ops.add(child);
                }
                ++idz;
            }
            ++idx;
        }
        return ops.toArray();
    }

    public static void main(String[] args) {
        try {
            WSDLHelper help = new WSDLHelper("http://localhost/testWS/Service1.asmx?WSDL");
            long start = System.currentTimeMillis();
            help.parse();
            String[] methods = help.getWebMethods();
            System.out.println("el: " + (System.currentTimeMillis() - start));
            int idx = 0;
            while (idx < methods.length) {
                System.out.println("method name: " + methods[idx]);
                ++idx;
            }
            System.out.println("service url: " + help.getBinding());
        }
        catch (Exception exception) {
            System.out.println("main method catch:");
            exception.printStackTrace();
        }
    }
}

