/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.FileDataContainer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CSVRead
extends AbstractFunction
implements Serializable {
    protected static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.CSVRead");
    private static final String KEY = "__CSVRead";
    protected static final List desc = new LinkedList();
    protected static FileDataContainer fileData;
    protected String myValue = "<please supply a file>";
    protected String myName = "ThreadStringFromFile_";
    protected Object[] values;
    protected BufferedReader myBread;
    protected boolean reopenFile = true;
    protected static Hashtable threadData;

    public Object clone() {
        CSVRead newReader = new CSVRead();
        return newReader;
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        try {
            JMeterVariables vars = this.getVariables();
            ArrayList processedLines = null;
            String fileName = null;
            fileName = ((CompoundVariable)this.values[0]).execute();
            this.myName = ((CompoundVariable)this.values[1]).execute();
            FileDataContainer fileData = this.getFileData(fileName);
            if (this.myName.equals("next()") || this.myName.equals("next")) {
                fileData.incrementRowPosition();
                this.storeCurrentLine(null);
            }
            processedLines = this.reloadCurrentLine();
            if (fileData != null && processedLines == null) {
                processedLines = fileData.getNextLine();
                this.storeCurrentLine(processedLines);
            }
            int columnIndex = 0;
            try {
                columnIndex = Integer.parseInt(this.myName);
                this.myValue = (String)processedLines.get(columnIndex);
            }
            catch (Exception e) {
                this.myValue = "";
            }
            log.debug(Thread.currentThread().getName() + ">>>> execute (" + fileName + " , " + this.myName + ")   " + this.hashCode());
        }
        catch (Exception e) {
            log.error("execute", (Throwable)e);
        }
        return this.myValue;
    }

    public List getArgumentDesc() {
        return desc;
    }

    protected synchronized FileDataContainer getFileData(String fileName) throws IOException {
        if (fileData == null) {
            fileData = this.load(fileName);
        }
        return fileData;
    }

    protected String getId() {
        return "" + Thread.currentThread().hashCode();
    }

    public String getReferenceKey() {
        return KEY;
    }

    protected static synchronized Hashtable getThreadData() {
        if (threadData == null) {
            threadData = new Hashtable();
        }
        return threadData;
    }

    private synchronized FileDataContainer load(String fileName) throws IOException {
        FileDataContainer fileData = new FileDataContainer();
        this.openFile(fileName);
        if (null != this.myBread) {
            try {
                String line = this.myBread.readLine();
                while (line != null) {
                    fileData.addLine(line);
                    line = this.myBread.readLine();
                }
                this.myBread.close();
                this.setFileData(fileData);
                return fileData;
            }
            catch (IOException e) {
                log.error("load(" + fileName + ")", (Throwable)e);
                throw e;
            }
        }
        return fileData;
    }

    private void openFile(String fileName) {
        try {
            FileReader fis = new FileReader(fileName);
            this.myBread = new BufferedReader(fis);
        }
        catch (Exception e) {
            log.error("openFile", (Throwable)e);
        }
    }

    protected ArrayList reloadCurrentLine() throws InvalidVariableException {
        log.debug(this.getId() + "reloaded " + CSVRead.getThreadData().get(this.getId()));
        return (ArrayList)CSVRead.getThreadData().get(this.getId());
    }

    protected synchronized void reset() {
        log.debug(this.getId() + "reseting .... ");
        this.setFileData(null);
        threadData = new Hashtable();
    }

    protected synchronized void setFileData(FileDataContainer newValue) {
        fileData = newValue;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        log.debug(this.getId() + "setParameter - Collection" + parameters);
        this.reset();
        this.values = parameters.toArray();
        if (this.values.length > 2) {
            throw new InvalidVariableException();
        }
    }

    public void storeCurrentLine(ArrayList currentLine) throws InvalidVariableException {
        String id = this.getId();
        log.debug(id + "storing " + currentLine);
        if (currentLine == null) {
            CSVRead.getThreadData().remove(id);
        } else {
            CSVRead.getThreadData().put(id, currentLine);
        }
    }

    static {
        threadData = null;
        desc.add(JMeterUtils.getResString((String)"csvread_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"column_number"));
    }
}

