/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class FileDataContainer {
    private ArrayList fileData;
    private int rowPosition = -1;
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.FileDataContainer");

    public FileDataContainer() {
        this.fileData = new ArrayList();
    }

    public FileDataContainer(ArrayList newFileData) {
        this.fileData = newFileData;
    }

    public void addLine(String newLine) {
        this.fileData.add(this.processNextCSVLine(newLine));
    }

    public ArrayList getNextLine() {
        ArrayList result = null;
        if (this.fileData != null && this.fileData.size() > 0) {
            if (this.rowPosition == -1) {
                this.rowPosition = 0;
            }
            result = (ArrayList)this.fileData.get(this.rowPosition);
        }
        return result;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public void incrementRowPosition() {
        if (this.fileData != null && this.fileData.size() > 0) {
            ++this.rowPosition;
            if (this.rowPosition >= this.fileData.size()) {
                this.rowPosition = 0;
            }
        }
    }

    protected ArrayList processNextCSVLine(String theLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokener = new StringTokenizer(theLine, ",");
        while (tokener.hasMoreTokens()) {
            String token = tokener.nextToken();
            result.add(token);
        }
        return result;
    }
}

