/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class IterationCounter
extends AbstractFunction
implements Serializable {
    private static final List desc = new LinkedList();
    private static final String KEY = "__counter";
    private Object[] variables;
    private int[] counter = new int[1];

    public Object clone() {
        IterationCounter newCounter = new IterationCounter();
        newCounter.counter = this.counter;
        return newCounter;
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        this.counter[0] = this.counter[0] + 1;
        JMeterVariables vars = this.getVariables();
        boolean perThread = new Boolean(((CompoundVariable)this.variables[0]).execute());
        String varName = ((CompoundVariable)this.variables[this.variables.length - 1]).execute();
        String counterString = "";
        counterString = perThread ? Integer.toString(vars.getIteration()) : String.valueOf(this.counter[0]);
        vars.put(varName, counterString);
        return counterString;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        this.variables = parameters.toArray();
        if (this.variables.length < 2) {
            throw new InvalidVariableException();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"iteration_counter_arg_1"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }
}

