/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class Property
extends AbstractFunction
implements Serializable {
    private static final List desc = new LinkedList();
    private static final String KEY = "__property";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 2;
    private Object[] values;

    public Object clone() {
        return new Property();
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String propertyName = ((CompoundVariable)this.values[0]).execute();
        String propertyValue = JMeterUtils.getPropDefault((String)propertyName, (String)propertyName);
        if (this.values.length > 1) {
            String variableName = ((CompoundVariable)this.values[1]).execute();
            this.getVariables().put(variableName, propertyValue);
        }
        return propertyValue;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        this.values = parameters.toArray();
        if (this.values.length < 1 || this.values.length > 2) {
            throw new InvalidVariableException("Parameter Count not between 1 & 2");
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"property_name_param"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }
}

