/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class Random
extends AbstractFunction
implements Serializable {
    private static final List desc = new LinkedList();
    private static final String KEY = "__Random";
    private CompoundVariable varName;
    private CompoundVariable minimum;
    private CompoundVariable maximum;

    public Object clone() {
        Random newRandom = new Random();
        return newRandom;
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        int min = Integer.parseInt(this.minimum.execute());
        int max = Integer.parseInt(this.maximum.execute());
        int rand = (int)Math.round((double)min + Math.random() * (double)(max - min));
        String randString = Integer.toString(rand);
        vars.put(this.varName.execute(), randString);
        return randString;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        Object[] values = parameters.toArray();
        if (values.length < 3) {
            throw new InvalidVariableException();
        }
        this.varName = (CompoundVariable)values[2];
        this.minimum = (CompoundVariable)values[0];
        this.maximum = (CompoundVariable)values[1];
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"minimum_param"));
        desc.add(JMeterUtils.getResString((String)"maximum_param"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }
}

