/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;

public class RegexFunction
extends AbstractFunction
implements Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    public static final String ALL = "ALL";
    public static final String RAND = "RAND";
    public static final String KEY = "__regexFunction";
    Object[] values;
    private static Random rand = new Random();
    private static List desc = new LinkedList();
    Pattern searchPattern;
    Object[] template;
    String valueIndex = "";
    String defaultValue;
    String between = "";
    transient PatternCompiler compiler = new Perl5Compiler();
    Pattern templatePattern;
    private String name = "";
    private static ThreadLocal localMatcher = new ThreadLocal(){

        protected Object initialValue() {
            return new Perl5Matcher();
        }
    };

    public RegexFunction() {
        try {
            this.templatePattern = this.compiler.compile("\\$(\\d+)\\$");
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
        }
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        try {
            String dv;
            this.searchPattern = this.compiler.compile(((CompoundVariable)this.values[0]).execute());
            this.generateTemplate(((CompoundVariable)this.values[1]).execute());
            if (this.values.length > 2) {
                this.valueIndex = ((CompoundVariable)this.values[2]).execute();
            }
            if (this.valueIndex.equals("")) {
                this.valueIndex = "1";
            }
            if (this.values.length > 3) {
                this.between = ((CompoundVariable)this.values[3]).execute();
            }
            if (this.values.length > 4 && !(dv = ((CompoundVariable)this.values[4]).execute()).equals("")) {
                this.defaultValue = dv;
            }
            if (this.values.length > 5) {
                this.name = ((CompoundVariable)this.values[this.values.length - 1]).execute();
            }
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
            throw new InvalidVariableException("Bad regex pattern");
        }
        catch (Exception e) {
            throw new InvalidVariableException(e.getMessage());
        }
        this.getVariables().put(this.name, this.defaultValue);
        if (previousResult == null || previousResult.getResponseData() == null) {
            return this.defaultValue;
        }
        ArrayList<MatchResult> collectAllMatches = new ArrayList<MatchResult>();
        try {
            PatternMatcher matcher = (PatternMatcher)localMatcher.get();
            String responseText = new String(previousResult.getResponseData());
            PatternMatcherInput input = new PatternMatcherInput(responseText);
            while (matcher.contains(input, this.searchPattern)) {
                MatchResult match = matcher.getMatch();
                collectAllMatches.add(match);
            }
        }
        catch (NumberFormatException e) {
            log.error("", (Throwable)e);
            return this.defaultValue;
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        if (collectAllMatches.size() == 0) {
            return this.defaultValue;
        }
        if (this.valueIndex.equals(ALL)) {
            StringBuffer value = new StringBuffer();
            Iterator it = collectAllMatches.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    value.append(this.between);
                } else {
                    first = false;
                }
                value.append(this.generateResult((MatchResult)it.next()));
            }
            return value.toString();
        }
        if (this.valueIndex.equals(RAND)) {
            MatchResult result = (MatchResult)collectAllMatches.get(rand.nextInt(collectAllMatches.size()));
            return this.generateResult(result);
        }
        try {
            int index = Integer.parseInt(this.valueIndex) - 1;
            MatchResult result = (MatchResult)collectAllMatches.get(index);
            return this.generateResult(result);
        }
        catch (NumberFormatException e) {
            float ratio = Float.parseFloat(this.valueIndex);
            MatchResult result = (MatchResult)collectAllMatches.get((int)((double)((float)collectAllMatches.size() * ratio) + 0.5) - 1);
            return this.generateResult(result);
        }
        catch (IndexOutOfBoundsException e) {
            return this.defaultValue;
        }
    }

    private void saveGroups(MatchResult result) {
        if (result != null) {
            JMeterVariables vars = this.getVariables();
            int x = 0;
            while (x < result.groups()) {
                vars.put(this.name + "_g" + x, result.group(x));
                ++x;
            }
        }
    }

    public List getArgumentDesc() {
        return desc;
    }

    private String generateResult(MatchResult match) {
        this.saveGroups(match);
        StringBuffer result = new StringBuffer();
        int a = 0;
        while (a < this.template.length) {
            if (this.template[a] instanceof String) {
                result.append(this.template[a]);
            } else {
                result.append(match.group(((Integer)this.template[a]).intValue()));
            }
            ++a;
        }
        JMeterVariables vars = this.getVariables();
        vars.put(this.name, result.toString());
        return result.toString();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        this.values = parameters.toArray();
        if (this.values.length < 2) {
            throw new InvalidVariableException();
        }
        this.defaultValue = "";
    }

    private void generateTemplate(String rawTemplate) {
        ArrayList pieces = new ArrayList();
        LinkedList<Integer> combined = new LinkedList<Integer>();
        Perl5Matcher matcher = new Perl5Matcher();
        Util.split(pieces, (PatternMatcher)new Perl5Matcher(), (Pattern)this.templatePattern, (String)rawTemplate);
        PatternMatcherInput input = new PatternMatcherInput(rawTemplate);
        boolean count = false;
        Iterator iter = pieces.iterator();
        boolean startsWith = this.isFirstElementGroup(rawTemplate);
        while (iter.hasNext()) {
            boolean matchExists = matcher.contains(input, this.templatePattern);
            if (startsWith) {
                if (matchExists) {
                    combined.add(new Integer(matcher.getMatch().group(1)));
                }
                combined.add((Integer)iter.next());
                continue;
            }
            combined.add((Integer)iter.next());
            if (!matchExists) continue;
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        if (matcher.contains(input, this.templatePattern)) {
            combined.add(new Integer(matcher.getMatch().group(1)));
        }
        this.template = combined.toArray();
    }

    private boolean isFirstElementGroup(String rawData) {
        try {
            Pattern pattern = this.compiler.compile("^\\$\\d+\\$");
            return new Perl5Matcher().contains(rawData, pattern);
        }
        catch (MalformedPatternException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    static {
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_1"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_2"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_3"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_4"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_5"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }
}

