/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class StringFromFile
extends AbstractFunction
implements Serializable {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static final List desc = new LinkedList();
    private static final String KEY = "_StringFromFile";
    private String myValue = "<please supply a file>";
    private String myName = "StringFromFile_";
    private Object[] values;
    private BufferedReader myBread;
    private boolean reopenFile = true;
    private String fileName;

    public Object clone() {
        StringFromFile newReader = new StringFromFile();
        if (log.isDebugEnabled()) {
            log.debug(this + "::StringFromFile.clone()", new Throwable("debug"));
        }
        return newReader;
    }

    private void openFile() {
        this.fileName = ((CompoundVariable)this.values[0]).execute();
        try {
            FileReader fis = new FileReader(this.fileName);
            this.myBread = new BufferedReader(fis);
            log.info("Opened " + this.fileName);
        }
        catch (Exception e) {
            log.error("Error in openFile " + this.fileName, (Throwable)e);
        }
    }

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        if (this.values.length >= 2) {
            this.myName = ((CompoundVariable)this.values[1]).execute();
        }
        this.myValue = "**ERR**";
        if (null != this.myBread) {
            try {
                String line = this.myBread.readLine();
                if (line == null && this.reopenFile) {
                    log.info("Reached EOF on " + this.fileName);
                    this.myBread.close();
                    this.openFile();
                    line = this.myBread.readLine();
                }
                this.myValue = line;
            }
            catch (Exception e) {
                log.error("Error reading file " + this.fileName, (Throwable)e);
            }
        }
        vars.put(this.myName, this.myValue);
        log.debug(this + "::StringFromFile.execute() value " + this.myValue);
        return this.myValue;
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
        log.debug(this + "::StringFromFile.setParameters()");
        this.values = parameters.toArray();
        if (this.values.length > 2 || this.values.length < 1) {
            throw new InvalidVariableException("Wrong number of parameters");
        }
        this.openFile();
        log.info("Variable name: " + this.myName);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"string_from_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"function_name_param"));
    }
}

