/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;

public class TestPlanGui
extends AbstractJMeterGuiComponent {
    private JCheckBox functionalMode;
    private JCheckBox serializedMode;
    private ArgumentsPanel argsPanel;
    static /* synthetic */ Class class$org$apache$jmeter$threads$gui$ThreadGroupGui;

    public TestPlanGui() {
        this.init();
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        JMenu addMenu = new JMenu(JMeterUtils.getResString("Add"));
        addMenu.add(MenuFactory.makeMenuItem(new ThreadGroupGui().getStaticLabel(), (class$org$apache$jmeter$threads$gui$ThreadGroupGui == null ? (class$org$apache$jmeter$threads$gui$ThreadGroupGui = TestPlanGui.class$("org.apache.jmeter.threads.gui.ThreadGroupGui")) : class$org$apache$jmeter$threads$gui$ThreadGroupGui).getName(), "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_listener", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_config_element", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_assertions", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_pre_processors", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_post_processors", "Add"));
        addMenu.add(MenuFactory.makeMenu("menu_timer", "Add"));
        pop.add(addMenu);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public TestElement createTestElement() {
        TestPlan tp = new TestPlan();
        this.modifyTestElement(tp);
        return tp;
    }

    public void modifyTestElement(TestElement plan) {
        super.configureTestElement(plan);
        if (plan instanceof TestPlan) {
            TestPlan tp = (TestPlan)plan;
            tp.setFunctionalMode(this.functionalMode.isSelected());
            tp.setSerialized(this.serializedMode.isSelected());
            tp.setUserDefinedVariables((Arguments)this.argsPanel.createTestElement());
        }
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("test_plan");
    }

    public Collection getMenuCategories() {
        return null;
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.functionalMode.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("TestPlan.functional_mode"));
        this.serializedMode.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("TestPlan.serialize_threadgroups"));
        if (el.getProperty("TestPlan.user_defined_variables") != null) {
            this.argsPanel.configure((Arguments)el.getProperty("TestPlan.user_defined_variables").getObjectValue());
        }
    }

    private JPanel createVariablePanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString("user_defined_variables"));
        return this.argsPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)this.createVariablePanel(), "Center");
        VerticalPanel southPanel = new VerticalPanel();
        this.serializedMode = new JCheckBox(JMeterUtils.getResString("testplan.serialized"));
        southPanel.add(this.serializedMode);
        this.functionalMode = new JCheckBox(JMeterUtils.getResString("functional_mode"));
        southPanel.add(this.functionalMode);
        JTextArea explain = new JTextArea(JMeterUtils.getResString("functional_mode_explanation"));
        explain.setEditable(false);
        explain.setBackground(this.getBackground());
        southPanel.add(explain);
        this.add((Component)southPanel, "South");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

