/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.rmi.RemoteException;
import java.util.Iterator;
import org.apache.jmeter.samplers.RemoteListenerWrapper;
import org.apache.jmeter.samplers.RemoteSampleListenerImpl;
import org.apache.jmeter.samplers.RemoteSampleListenerWrapper;
import org.apache.jmeter.samplers.RemoteTestListenerWrapper;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConvertListeners
implements HashTreeTraverser {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");

    public void addNode(Object node, HashTree subTree) {
        if (node instanceof ThreadGroup) {
            log.info("num threads = " + ((ThreadGroup)node).getNumThreads());
        }
        Iterator iter = subTree.list().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof ThreadGroup) {
                log.info("num threads = " + ((ThreadGroup)item).getNumThreads());
            }
            if (!(item instanceof Remoteable) || !(item instanceof TestListener) && !(item instanceof SampleListener)) continue;
            try {
                AbstractTestElement wrap;
                RemoteSampleListenerImpl rtl = new RemoteSampleListenerImpl(item);
                if (item instanceof TestListener && item instanceof SampleListener) {
                    wrap = new RemoteListenerWrapper(rtl);
                    subTree.replace(item, (Object)wrap);
                    continue;
                }
                if (item instanceof TestListener) {
                    wrap = new RemoteTestListenerWrapper(rtl);
                    subTree.replace(item, (Object)wrap);
                    continue;
                }
                wrap = new RemoteSampleListenerWrapper(rtl);
                subTree.replace(item, (Object)wrap);
            }
            catch (RemoteException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }
}

