/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.PreCompiler;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class StandardJMeterEngine
implements JMeterEngine,
JMeterThreadMonitor,
Runnable,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    private Thread runningThread;
    private static long WAIT_TO_DIE = 5000L;
    Map allThreads = new HashMap();
    boolean running = false;
    boolean serialized = false;
    boolean schcdule_run = false;
    HashTree test;
    SearchByClass testListeners;
    String host = null;
    ListenerNotifier notifier;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestPlan;
    static /* synthetic */ Class class$org$apache$jmeter$threads$ThreadGroup;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestListener;

    public StandardJMeterEngine() {
    }

    public StandardJMeterEngine(String host) {
        this();
        this.host = host;
    }

    public void configure(HashTree testTree) {
        this.test = testTree;
    }

    public void setHost(String host) {
        this.host = host;
    }

    protected HashTree getTestTree() {
        return this.test;
    }

    protected void compileTree() {
        PreCompiler compiler = new PreCompiler();
        this.getTestTree().traverse((HashTreeTraverser)compiler);
    }

    public void runTest() throws JMeterEngineException {
        try {
            this.runningThread = new Thread(this);
            this.runningThread.start();
        }
        catch (Exception err) {
            this.stopTest();
            StringWriter string = new StringWriter();
            PrintWriter writer = new PrintWriter(string);
            err.printStackTrace(writer);
            throw new JMeterEngineException(string.toString());
        }
    }

    private void removeThreadGroups(List elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof ThreadGroup) {
                iter.remove();
                continue;
            }
            if (item instanceof TestElement) continue;
            iter.remove();
        }
    }

    protected void setMode() {
        SearchByClass testPlan = new SearchByClass(class$org$apache$jmeter$testelement$TestPlan == null ? (class$org$apache$jmeter$testelement$TestPlan = StandardJMeterEngine.class$("org.apache.jmeter.testelement.TestPlan")) : class$org$apache$jmeter$testelement$TestPlan);
        this.getTestTree().traverse((HashTreeTraverser)testPlan);
        Object[] plan = testPlan.getSearchResults().toArray();
        ResultCollector.enableFunctionalMode(((TestPlan)plan[0]).isFunctionalMode());
    }

    protected void notifyTestListenersOfStart() {
        Iterator iter = this.testListeners.getSearchResults().iterator();
        while (iter.hasNext()) {
            if (this.host == null) {
                ((TestListener)iter.next()).testStarted();
                continue;
            }
            ((TestListener)iter.next()).testStarted(this.host);
        }
    }

    protected void notifyTestListenersOfEnd() {
        Iterator iter = this.testListeners.getSearchResults().iterator();
        while (iter.hasNext()) {
            if (this.host == null) {
                ((TestListener)iter.next()).testEnded();
                continue;
            }
            ((TestListener)iter.next()).testEnded(this.host);
        }
    }

    private ListedHashTree cloneTree(ListedHashTree tree) {
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    public void reset() {
        if (this.running) {
            this.stopTest();
        }
    }

    public synchronized void threadFinished(JMeterThread thread) {
        this.allThreads.remove(thread);
        if (!this.serialized && this.allThreads.size() == 0 && !this.schcdule_run) {
            this.stopTest();
        }
    }

    public synchronized void stopTest() {
        Thread stopThread = new Thread(new StopTest());
        stopThread.start();
    }

    public void run() {
        log.info("Running the test!");
        this.running = true;
        SearchByClass testPlan = new SearchByClass(class$org$apache$jmeter$testelement$TestPlan == null ? (class$org$apache$jmeter$testelement$TestPlan = StandardJMeterEngine.class$("org.apache.jmeter.testelement.TestPlan")) : class$org$apache$jmeter$testelement$TestPlan);
        this.getTestTree().traverse((HashTreeTraverser)testPlan);
        Object[] plan = testPlan.getSearchResults().toArray();
        if (((TestPlan)plan[0]).isSerialized()) {
            this.serialized = true;
        }
        this.compileTree();
        LinkedList testLevelElements = new LinkedList(this.getTestTree().list(this.getTestTree().getArray()[0]));
        this.removeThreadGroups(testLevelElements);
        SearchByClass searcher = new SearchByClass(class$org$apache$jmeter$threads$ThreadGroup == null ? (class$org$apache$jmeter$threads$ThreadGroup = StandardJMeterEngine.class$("org.apache.jmeter.threads.ThreadGroup")) : class$org$apache$jmeter$threads$ThreadGroup);
        this.testListeners = new SearchByClass(class$org$apache$jmeter$testelement$TestListener == null ? (class$org$apache$jmeter$testelement$TestListener = StandardJMeterEngine.class$("org.apache.jmeter.testelement.TestListener")) : class$org$apache$jmeter$testelement$TestListener);
        this.setMode();
        this.getTestTree().traverse((HashTreeTraverser)this.testListeners);
        this.getTestTree().traverse((HashTreeTraverser)searcher);
        TestCompiler.initialize();
        Iterator iter = searcher.getSearchResults().iterator();
        if (iter.hasNext()) {
            this.notifyTestListenersOfStart();
        }
        this.notifier = new ListenerNotifier();
        this.schcdule_run = true;
        JMeterContextService.getContext().setSamplingStarted(true);
        int groupCount = 1;
        while (iter.hasNext()) {
            ThreadGroup group = (ThreadGroup)iter.next();
            JMeterThread[] threads = new JMeterThread[group.getNumThreads()];
            log.info("Starting " + threads.length + " test threads");
            int i = 0;
            while (this.running && i < threads.length) {
                ListedHashTree threadGroupTree = (ListedHashTree)searcher.getSubTree((Object)group);
                threadGroupTree.add((Object)group, testLevelElements);
                threads[i] = new JMeterThread((HashTree)this.cloneTree(threadGroupTree), this, this.notifier);
                threads[i].setThreadNum(i);
                threads[i].setInitialContext(JMeterContextService.getContext());
                threads[i].setInitialDelay((int)((float)(group.getRampUp() * 1000) / (float)group.getNumThreads() * (float)i));
                threads[i].setThreadName(group.getName() + groupCount++ + "-" + (i + 1));
                this.scheduleThread(threads[i], group);
                Thread newThread = new Thread(threads[i]);
                newThread.setName(threads[i].getThreadName());
                this.allThreads.put(threads[i], newThread);
                if (this.serialized && !iter.hasNext() && i == threads.length - 1) {
                    this.serialized = false;
                }
                newThread.start();
                ++i;
            }
            this.schcdule_run = false;
            if (!this.serialized) continue;
            while (this.running && this.allThreads.size() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private void scheduleThread(JMeterThread thread, ThreadGroup group) {
        if (group.getScheduler()) {
            thread.setStartTime(group.getStartTime());
            thread.setEndTime(group.getEndTime());
            thread.setScheduled(true);
        }
    }

    private void verifyThreadsStopped() {
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            Thread t = (Thread)this.allThreads.get(iter.next());
            if (t != null && t.isAlive()) {
                try {
                    t.join(WAIT_TO_DIE);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (t.isAlive()) {
                    log.info("Thread won't die: " + t.getName());
                }
            }
            log.debug("finished thread");
        }
    }

    private void tellThreadsToStop() {
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            JMeterThread item = (JMeterThread)iter.next();
            item.stop();
            Thread t = (Thread)this.allThreads.get(item);
            if (t != null) {
                t.interrupt();
                continue;
            }
            log.warn("Lost thread: " + item.getThreadName());
            this.allThreads.remove(item);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StopTest
    implements Runnable {
        private StopTest() {
        }

        public void run() {
            if (StandardJMeterEngine.this.running) {
                StandardJMeterEngine.this.running = false;
                StandardJMeterEngine.this.tellThreadsToStop();
                try {
                    Thread.sleep(10 * StandardJMeterEngine.this.allThreads.size());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StandardJMeterEngine.this.verifyThreadsStopped();
                StandardJMeterEngine.this.notifyTestListenersOfEnd();
            }
        }
    }
}

